/*
 * Decompiled with CFR 0.152.
 */
package io.netty.build.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.regex.Pattern;

public class StaticFinalBufferCheck
extends AbstractCheck {
    private static final Pattern pattern = Pattern.compile("(Unpooled\\s*\\.)?unreleasableBuffer\\(.*?\\)\\s*\\.asReadOnly\\(\\)");

    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public void visitToken(DetailAST ast) {
        DetailAST modifiersAST = ast.findFirstToken(5);
        boolean isStatic = modifiersAST.findFirstToken(64) != null;
        boolean isFinal = modifiersAST.findFirstToken(39) != null;
        FullIdent typeIdent = FullIdent.createFullIdentBelow((DetailAST)ast.findFirstToken(13));
        if (!(isStatic && isFinal && typeIdent.getText().endsWith("Buf"))) {
            return;
        }
        DetailAST assignAST = ast.findFirstToken(80);
        DetailAST semiAST = ast.findFirstToken(45);
        if (assignAST == null || semiAST == null) {
            this.log(ast.getLineNo(), "Missing assignment for static final buffer", new Object[0]);
            return;
        }
        FileContents fc = this.getFileContents();
        StringBuilder sb = new StringBuilder();
        for (int i = assignAST.getLineNo(); i <= semiAST.getLineNo(); ++i) {
            sb.append(fc.getLine(i - 1).trim());
        }
        if (!pattern.matcher(sb.toString()).find()) {
            this.log(ast.getLineNo(), "static final buffer assignment should match pattern " + pattern, new Object[0]);
        }
    }
}

