/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.milvus.bulkwriter.response.BulkImportResponse;
import io.milvus.bulkwriter.response.GetImportProgressResponse;
import io.milvus.bulkwriter.response.ListImportJobsResponse;
import io.milvus.bulkwriter.response.RestfulResponse;
import io.milvus.common.utils.ExceptionUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class CloudImport {
    public static BulkImportResponse bulkImport(String url, String apiKey, String objectUrl, String accessKey, String secretKey, String clusterId, String collectionName) throws MalformedURLException {
        String protocol = new URL(url).getProtocol();
        String requestURL = protocol.startsWith("http") ? url + "/v1/vector/collections/import" : String.format("https://%s/v1/vector/collections/import", url);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objectUrl", objectUrl);
        params.put("accessKey", accessKey);
        params.put("secretKey", secretKey);
        params.put("clusterId", clusterId);
        params.put("collectionName", collectionName);
        String body = CloudImport.postRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)new Gson().fromJson(body, new TypeToken<RestfulResponse<BulkImportResponse>>(){}.getType());
        CloudImport.handleResponse(url, response);
        return (BulkImportResponse)response.getData();
    }

    public static GetImportProgressResponse getImportProgress(String url, String apiKey, String jobId, String clusterId) throws MalformedURLException {
        String protocol = new URL(url).getProtocol();
        String requestURL = protocol.startsWith("http") ? url + "/v1/vector/collections/import/get" : String.format("https://%s/v1/vector/collections/import/get", url);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clusterId", clusterId);
        params.put("jobId", jobId);
        String body = CloudImport.getRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)new Gson().fromJson(body, new TypeToken<RestfulResponse<GetImportProgressResponse>>(){}.getType());
        CloudImport.handleResponse(url, response);
        return (GetImportProgressResponse)response.getData();
    }

    public static ListImportJobsResponse listImportJobs(String url, String apiKey, String clusterId, int pageSize, int currentPage) throws MalformedURLException {
        String protocol = new URL(url).getProtocol();
        String requestURL = protocol.startsWith("http") ? url + "/v1/vector/collections/import/list" : String.format("https://%s/v1/vector/collections/import/list", url);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clusterId", clusterId);
        params.put("pageSize", pageSize);
        params.put("currentPage", currentPage);
        String body = CloudImport.getRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)new Gson().fromJson(body, new TypeToken<RestfulResponse<ListImportJobsResponse>>(){}.getType());
        CloudImport.handleResponse(url, response);
        return (ListImportJobsResponse)response.getData();
    }

    private static String postRequest(String url, String apiKey, Map<String, Object> params, int timeout) {
        try {
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).connectTimeout(timeout)).headers(CloudImport.httpHeaders(apiKey))).body(params).asString();
            if (response.getStatus() == 200) {
                return (String)response.getBody();
            }
            ExceptionUtils.throwUnExpectedException(String.format("Failed to post url: %s, status code: %s", url, response.getStatus()));
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException(String.format("Failed to post url: %s, error: %s", url, e));
        }
        return null;
    }

    private static String getRequest(String url, String apiKey, Map<String, Object> params, int timeout) {
        try {
            HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)url).connectTimeout(timeout)).headers(CloudImport.httpHeaders(apiKey))).queryString(params)).asString();
            if (response.getStatus() == 200) {
                return (String)response.getBody();
            }
            ExceptionUtils.throwUnExpectedException(String.format("Failed to get url: %s, status code: %s", url, response.getStatus()));
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException(String.format("Failed to get url: %s, error: %s", url, e));
        }
        return null;
    }

    private static Map<String, String> httpHeaders(String apiKey) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_0) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11");
        header.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        header.put("Accept-Encodin", "gzip,deflate,sdch");
        header.put("Accept-Languag", "en-US,en;q=0.5");
        header.put("Authorization", "Bearer " + apiKey);
        return header;
    }

    private static void handleResponse(String url, RestfulResponse res) {
        int innerCode = res.getCode();
        if (innerCode != 200) {
            String innerMessage = res.getMessage();
            ExceptionUtils.throwUnExpectedException(String.format("Failed to request url: %s, code: %s, message: %s", url, innerCode, innerMessage));
        }
    }
}

