/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.impl.compression.AbstractCompressionCodec;
import io.jsonwebtoken.lang.Objects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCompressionCodec
extends AbstractCompressionCodec
implements CompressionCodec {
    private static final String GZIP = "GZIP";

    @Override
    public String getAlgorithmName() {
        return GZIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] doDecompress(byte[] compressed) throws IOException {
        byte[] byArray;
        byte[] buffer = new byte[512];
        ByteArrayOutputStream outputStream = null;
        GZIPInputStream gzipInputStream = null;
        ByteArrayInputStream inputStream = null;
        try {
            int read;
            inputStream = new ByteArrayInputStream(compressed);
            gzipInputStream = new GZIPInputStream(inputStream);
            outputStream = new ByteArrayOutputStream();
            while ((read = gzipInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(inputStream, gzipInputStream, outputStream);
            throw throwable;
        }
        Objects.nullSafeClose(inputStream, gzipInputStream, outputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] doCompress(byte[] payload) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream compressorOutputStream = new GZIPOutputStream((OutputStream)outputStream, true);
        try {
            compressorOutputStream.write(payload, 0, payload.length);
            compressorOutputStream.finish();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(compressorOutputStream, outputStream);
            throw throwable;
        }
        Objects.nullSafeClose(compressorOutputStream, outputStream);
        return byArray;
    }
}

