/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.MarkedSection;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Section;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import fr.opensagres.xdocreport.itext.extension.IParagraphFactory;
import fr.opensagres.xdocreport.itext.extension.ParagraphFactory;
import java.util.ArrayList;

public class ExtendedSection
extends Section {
    private PdfPCell cell;
    private Paragraph computedTitle;
    private Paragraph bookmarkTitleParagraph;

    public ExtendedSection(Paragraph title, int numberDepth) {
        super(title, numberDepth);
    }

    public Paragraph getTitle() {
        if (this.computedTitle == null) {
            this.bookmarkTitleParagraph = ExtendedSection.ancestorConstructTitle(this.getParagraphFactory(), this.title, this.numbers, this.numberDepth, this.numberStyle);
            this.computedTitle = ExtendedSection.constructTitle(this.getParagraphFactory(), this.bookmarkTitleParagraph, this.numbers, this.numberDepth, this.numberStyle, this.cell);
        }
        return this.computedTitle;
    }

    public Paragraph getBookmarkTitle() {
        return this.bookmarkTitleParagraph;
    }

    public Section addSection(float indentation, Paragraph title, int numberDepth) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        ExtendedSection section = new ExtendedSection(title, numberDepth);
        section.setIndentation(indentation);
        this.add((Element)section);
        return section;
    }

    public MarkedSection addMarkedSection() {
        MarkedSection section = new MarkedSection((Section)new ExtendedSection(null, this.numberDepth + 1));
        this.add((Element)section);
        return section;
    }

    public static Paragraph constructTitle(IParagraphFactory factory, Paragraph ancestorTitle, ArrayList numbers, int numberDepth, int numberStyle, PdfPCell cell) {
        if (ancestorTitle != null && cell != null) {
            Paragraph newTitle = factory.createParagraph();
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            cell.addElement((Element)ancestorTitle);
            table.addCell(cell);
            newTitle.add((Element)table);
            return newTitle;
        }
        return ancestorTitle;
    }

    public static Paragraph ancestorConstructTitle(IParagraphFactory factory, Paragraph title, ArrayList numbers, int numberDepth, int numberStyle) {
        if (title == null) {
            return null;
        }
        int depth = Math.min(numbers.size(), numberDepth);
        if (depth < 1) {
            return title;
        }
        StringBuffer buf = new StringBuffer(" ");
        for (int i = 0; i < depth; ++i) {
            buf.insert(0, ".");
            buf.insert(0, (Integer)numbers.get(i));
        }
        if (numberStyle == 1) {
            buf.deleteCharAt(buf.length() - 2);
        }
        Paragraph result = factory.createParagraph(title);
        result.add(0, (Element)new Chunk(buf.toString(), title.getFont()));
        return result;
    }

    public PdfPCell getPdfPCell() {
        if (this.cell != null) {
            return this.cell;
        }
        this.cell = this.createPdfPCell();
        return this.cell;
    }

    private synchronized PdfPCell createPdfPCell() {
        if (this.cell != null) {
            return this.cell;
        }
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPadding(0.0f);
        return cell;
    }

    protected IParagraphFactory getParagraphFactory() {
        return ParagraphFactory.getDefault();
    }
}

