/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import fr.opensagres.xdocreport.itext.extension.IMasterPage;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;

public class ExtendedHeaderFooter
extends PdfPageEventHelper {
    protected final ExtendedDocument document;
    private IMasterPage masterPage;

    public ExtendedHeaderFooter(ExtendedDocument document) {
        this.document = document;
    }

    public void onStartPage(PdfWriter writer, Document doc) {
        if (this.masterPage == null) {
            this.masterPage = this.document.getDefaultMasterPage();
        }
        if (this.masterPage != null) {
            float y;
            float x;
            IMasterPageHeaderFooter header = this.masterPage.getHeader();
            IMasterPageHeaderFooter footer = this.masterPage.getFooter();
            if (header != null) {
                x = this.document.getOriginMarginLeft();
                y = this.getHeaderY(header);
                header.writeSelectedRows(0, -1, x, y, writer.getDirectContentUnder());
            }
            if (footer != null) {
                x = this.document.getOriginMarginLeft();
                y = this.getFooterY(footer);
                footer.writeSelectedRows(0, -1, x, y, writer.getDirectContentUnder());
            }
        }
    }

    protected float getFooterY(IMasterPageHeaderFooter footer) {
        return this.document.getOriginMarginBottom() + footer.getTotalHeight();
    }

    protected float getHeaderY(IMasterPageHeaderFooter header) {
        return this.document.getPageSize().getHeight() - this.document.getOriginMarginTop();
    }

    public void setMasterPage(IMasterPage masterPage) {
        IMasterPageHeaderFooter header = masterPage.getHeader();
        IMasterPageHeaderFooter footer = masterPage.getFooter();
        float marginLeft = this.document.getOriginMarginLeft();
        float marginRight = this.document.getOriginMarginRight();
        float marginTop = this.document.getOriginMarginTop();
        if (header != null) {
            marginTop = this.adjustMargin(marginTop, header);
        }
        float marginBottom = this.document.getOriginMarginBottom();
        if (footer != null) {
            marginBottom = this.adjustMargin(marginBottom, footer);
        }
        this.document.setMargins(marginLeft, marginRight, marginTop, marginBottom);
        this.masterPage = masterPage;
    }

    protected float adjustMargin(float margin, IMasterPageHeaderFooter headerFooter) {
        return margin + headerFooter.getTotalHeight();
    }

    public IMasterPage getMasterPage() {
        return this.masterPage;
    }
}

