/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import fr.opensagres.xdocreport.itext.extension.ExtendedHeaderFooter;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfAWriter;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfWriter;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.itext.extension.IMasterPage;
import fr.opensagres.xdocreport.itext.extension.IPdfAWriterConfiguration;
import fr.opensagres.xdocreport.itext.extension.IPdfWriterConfiguration;
import fr.opensagres.xdocreport.itext.extension.PageOrientation;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ExtendedDocument
extends Document
implements IITextContainer {
    private Map<String, IMasterPage> masterPagesCache = new HashMap<String, IMasterPage>();
    private IMasterPage defaultMasterPage;
    private final ExtendedHeaderFooter headerFooter;
    protected final PdfWriter writer;
    protected float originMarginTop;
    protected float originMarginBottom;
    protected float originMarginRight;
    protected float originMarginLeft;
    private PageOrientation orientation = PageOrientation.Portrait;

    public ExtendedDocument(OutputStream out) throws DocumentException {
        this(out, (IPdfWriterConfiguration)null);
    }

    public ExtendedDocument(OutputStream out, IPdfWriterConfiguration configuration) throws DocumentException {
        this.writer = ExtendedPdfWriter.getInstance(this, out);
        if (configuration != null) {
            configuration.configure(this.writer);
        }
        this.headerFooter = this.createExtendedHeaderFooter();
        this.initAttributes();
    }

    public ExtendedDocument(OutputStream out, IPdfAWriterConfiguration configuration) throws DocumentException {
        if (configuration != null) {
            this.writer = ExtendedPdfAWriter.getInstance(this, out, configuration);
            configuration.configure((PdfAWriter)this.writer);
        } else {
            this.writer = ExtendedPdfAWriter.getInstance((Document)this, (OutputStream)out);
        }
        this.headerFooter = this.createExtendedHeaderFooter();
        this.initAttributes();
    }

    private void initAttributes() {
        this.writer.setPageEvent((PdfPageEvent)this.headerFooter);
        this.originMarginTop = this.marginTop;
        this.originMarginBottom = this.marginBottom;
        this.originMarginRight = this.marginRight;
        this.originMarginLeft = this.marginLeft;
    }

    protected ExtendedHeaderFooter createExtendedHeaderFooter() {
        return new ExtendedHeaderFooter(this);
    }

    public int getPageNumber() {
        return this.writer.getCurrentPageNumber();
    }

    public boolean setOriginalMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.originMarginTop = marginTop;
        this.originMarginBottom = marginBottom;
        this.originMarginRight = marginRight;
        this.originMarginLeft = marginLeft;
        return super.setMargins(marginLeft, marginRight, marginTop, marginBottom);
    }

    @Override
    public void addElement(Element element) {
        try {
            this.add(element);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public boolean add(Element element) throws DocumentException {
        if (!this.isOpen()) {
            this.open();
        }
        return super.add(element);
    }

    public IMasterPage getDefaultMasterPage() {
        return this.defaultMasterPage;
    }

    public float getOriginMarginBottom() {
        return this.originMarginBottom;
    }

    public float getOriginMarginLeft() {
        return this.originMarginLeft;
    }

    public float getOriginMarginRight() {
        return this.originMarginRight;
    }

    public float getOriginMarginTop() {
        return this.originMarginTop;
    }

    public void setActiveMasterPage(IMasterPage masterPage) {
        this.headerFooter.setMasterPage(masterPage);
    }

    public IMasterPage getActiveMasterPage() {
        return this.headerFooter.getMasterPage();
    }

    public void addMasterPage(IMasterPage currentMasterPage) {
        if (this.defaultMasterPage == null) {
            this.defaultMasterPage = currentMasterPage;
        }
        this.masterPagesCache.put(currentMasterPage.getName(), currentMasterPage);
    }

    public void setActiveMasterPage(String masterPageName) {
        IMasterPage masterPage = this.getMasterPage(masterPageName);
        if (masterPage != null) {
            this.setActiveMasterPage(masterPage);
        }
    }

    public IMasterPage getMasterPage(String masterPageName) {
        if (masterPageName == null) {
            return null;
        }
        return this.masterPagesCache.get(masterPageName);
    }

    @Override
    public IITextContainer getITextContainer() {
        return null;
    }

    @Override
    public void setITextContainer(IITextContainer container) {
    }

    public PageOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PageOrientation orientation) {
        if (!this.orientation.equals((Object)orientation)) {
            super.getPageSize().rotate();
        }
        this.orientation = orientation;
    }
}

