/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.ods.images;

import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.document.images.AbstractImageRegistry;
import fr.opensagres.xdocreport.document.images.ImageProviderInfo;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.text.DecimalFormat;

public class ODSImageRegistry
extends AbstractImageRegistry {
    private DecimalFormat df = new DecimalFormat("#");
    private static final String IMAGE_BASE_PATH = "Pictures/";

    public ODSImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider, FieldsMetadata fieldsMetadata) {
        super(readerProvider, writerProvider, outputStreamProvider, fieldsMetadata);
    }

    protected String getImageBasePath() {
        return IMAGE_BASE_PATH;
    }

    protected String getPath(ImageProviderInfo info) {
        return info.getImageBasePath() + info.getImageFileName();
    }

    public String getSize(float sizeAsPixel) {
        float sizeAsDxa = sizeAsPixel / 96.0f * 914400.0f;
        String s = this.df.format(sizeAsDxa);
        return s;
    }

    public Float getSize(String sizeAsDxa) {
        if (sizeAsDxa == null) {
            return null;
        }
        try {
            float sizeAsPixel = Float.parseFloat(sizeAsDxa);
            sizeAsPixel = sizeAsPixel / 914400.0f * 96.0f;
            return Float.valueOf(sizeAsPixel);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

