/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal.elements;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import fr.opensagres.poi.xwpf.converter.core.utils.ColorHelper;
import fr.opensagres.poi.xwpf.converter.pdf.internal.Converter;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import java.math.BigInteger;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;

public class StylableParagraph
extends ExtendedParagraph
implements IITextContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private final StylableDocument ownerDocument;
    private IITextContainer parent;
    private String listItemText;
    private Float originMultipliedLeading = Float.valueOf(1.0f);
    private String listItemFontFamily;
    private Float listItemFontSize;
    private int listItemFontStyle = -1;
    private BaseColor listItemFontColor;

    public StylableParagraph(StylableDocument ownerDocument, IITextContainer parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public StylableParagraph(StylableDocument ownerDocument, Paragraph title, IITextContainer parent) {
        super(title);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public IITextContainer getParent() {
        return this.parent;
    }

    public StylableDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public void setBorder(CTBorder border, int borderSide) {
        boolean noBorder;
        if (border == null) {
            return;
        }
        boolean bl = noBorder = STBorder.NONE == border.getVal() || STBorder.NIL == border.getVal();
        if (noBorder) {
            return;
        }
        float size = -1.0f;
        BigInteger borderSize = border.getSz();
        if (borderSize != null) {
            size = borderSize.floatValue() / 8.0f;
        }
        BaseColor borderColor = Converter.toBaseColor(ColorHelper.getBorderColor((CTBorder)border));
        Float space = null;
        BigInteger borderSpace = border.getSpace();
        if (borderSpace != null) {
            space = Float.valueOf(borderSpace.floatValue());
        }
        switch (borderSide) {
            case 1: {
                if (size != -1.0f) {
                    this.setBorderWidthTop(size);
                }
                if (borderColor != null) {
                    super.setBorderColorTop(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingTop(space.floatValue());
                break;
            }
            case 2: {
                if (size != -1.0f) {
                    this.setBorderWidthBottom(size);
                }
                if (borderColor != null) {
                    super.setBorderColorBottom(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingBottom(space.floatValue());
                break;
            }
            case 4: {
                if (size != -1.0f) {
                    this.setBorderWidthLeft(size);
                }
                if (borderColor != null) {
                    super.setBorderColorLeft(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingLeft(space.floatValue());
                break;
            }
            case 8: {
                if (size != -1.0f) {
                    this.setBorderWidthRight(size);
                }
                if (borderColor != null) {
                    super.setBorderColorRight(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingRight(space.floatValue());
            }
        }
    }

    public String getListItemText() {
        return this.listItemText;
    }

    public void setListItemText(String listItemText) {
        this.listItemText = listItemText;
    }

    public String getListItemFontFamily() {
        return this.listItemFontFamily;
    }

    public void setListItemFontFamily(String listItemFontFamily) {
        this.listItemFontFamily = listItemFontFamily;
    }

    public Float getListItemFontSize() {
        return this.listItemFontSize;
    }

    public void setListItemFontSize(Float listItemFontSize) {
        this.listItemFontSize = listItemFontSize;
    }

    public int getListItemFontStyle() {
        return this.listItemFontStyle;
    }

    public void setListItemFontStyle(int listItemFontStyle) {
        this.listItemFontStyle = listItemFontStyle;
    }

    public BaseColor getListItemFontColor() {
        return this.listItemFontColor;
    }

    public void setListItemFontColor(BaseColor listItemFontColor) {
        this.listItemFontColor = listItemFontColor;
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        super.setLeading(fixedLeading, multipliedLeading);
        this.originMultipliedLeading = Float.valueOf(multipliedLeading);
    }

    public void setMultipliedLeading(float multipliedLeading) {
        super.setMultipliedLeading(multipliedLeading);
        this.originMultipliedLeading = Float.valueOf(multipliedLeading);
    }

    public void adjustMultipliedLeading(Font font) {
        if (this.originMultipliedLeading != null && font != null && font.getBaseFont() != null) {
            float size = font.getSize();
            float ascender = font.getBaseFont().getFontDescriptor(9, size);
            float descender = -font.getBaseFont().getFontDescriptor(10, size);
            float margin = font.getBaseFont().getFontDescriptor(11, size);
            float multiplier = (ascender + descender + margin) / size;
            super.setMultipliedLeading(this.originMultipliedLeading.floatValue() * multiplier);
            float itextdescender = -font.getBaseFont().getFontDescriptor(3, size);
            float textRise = itextdescender + this.getTotalLeading() - font.getSize() * multiplier;
            List chunks = this.getChunks();
            for (Chunk chunk : chunks) {
                Font f = chunk.getFont();
                if (f != null) {
                    float s = f.getSize();
                    if (f.isUnderlined()) {
                        f.setStyle(f.getStyle() & 0xFFFFFFFB);
                        chunk.setUnderline(s * 1.0f / 17.0f, s * -1.0f / 7.0f + textRise);
                    }
                    if (f.isStrikethru()) {
                        f.setStyle(f.getStyle() & 0xFFFFFFF7);
                        chunk.setUnderline(s * 1.0f / 17.0f, s * 1.0f / 4.0f + textRise);
                    }
                }
                chunk.setTextRise(chunk.getTextRise() + textRise);
            }
        }
    }
}

