/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.stylable;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.factories.RomanAlphabetFactory;
import com.itextpdf.text.factories.RomanNumberFactory;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableElement;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableDocument;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableListItem;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableParagraph;
import fr.opensagres.odfdom.converter.pdf.internal.styles.Style;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleLineHeight;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleListProperties;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleNumFormat;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleParagraphProperties;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleTextProperties;
import java.util.List;
import java.util.Map;

public class StylableList
extends com.itextpdf.text.List
implements IStylableContainer {
    private IStylableContainer parent;
    private int listLevel;
    private boolean romanNumbered = false;
    private Style lastStyleApplied = null;

    public StylableList(StylableDocument ownerDocument, IStylableContainer parent, int listLevel) {
        this.parent = parent;
        this.listLevel = listLevel;
        super.setNumbered(false);
        super.setLettered(false);
        super.setLowercase(false);
        super.setPreSymbol("");
        super.setPostSymbol("");
        super.setListSymbol("");
        super.setAutoindent(false);
    }

    public int getIndex() {
        return this.first + this.list.size();
    }

    public void setFirst(int first) {
        this.first = first;
    }

    @Override
    public void addElement(Element element) {
        if (element instanceof StylableListItem) {
            StylableListItem li = (StylableListItem)element;
            boolean first = true;
            for (Element e : li.getElements()) {
                this.addElement(e, first);
                first = false;
            }
        }
    }

    private void addElement(Element element, boolean addLabel) {
        if (element instanceof Chunk) {
            Chunk ch = (Chunk)element;
            StylableParagraph p = new StylableParagraph(null, null);
            p.setFont(ch.getFont());
            p.addElement((Element)ch);
            element = p.getElement();
        }
        if (element instanceof Phrase) {
            StyleParagraphProperties paragraphProperties;
            StyleLineHeight lineHeightObj;
            IStylableElement stylableElement;
            Style style;
            Phrase p = (Phrase)element;
            StylableListItem li = new StylableListItem(p);
            Font symbolFont = this.symbol.getFont();
            if (symbolFont.isStandardFont()) {
                List chunks = p.getChunks();
                for (Chunk chunk : chunks) {
                    if (chunk.getFont().isStandardFont()) continue;
                    symbolFont = chunk.getFont();
                    break;
                }
                if (symbolFont.isStandardFont()) {
                    symbolFont = p.getFont();
                }
            }
            float lineHeight = 1.0f;
            boolean lineHeightProportional = true;
            if (element instanceof IStylableElement && (style = (stylableElement = (IStylableElement)element).getLastStyleApplied()) != null && (lineHeightObj = (paragraphProperties = style.getParagraphProperties()).getLineHeight()) != null && lineHeightObj.getLineHeight() != null) {
                lineHeight = lineHeightObj.getLineHeight().floatValue();
                lineHeightProportional = lineHeightObj.isLineHeightProportional();
            }
            if (addLabel) {
                if (this.numbered || this.lettered || this.romanNumbered) {
                    StringBuilder sbuf = new StringBuilder(this.preSymbol);
                    int index = this.first + this.list.size();
                    if (this.lettered) {
                        sbuf.append(RomanAlphabetFactory.getString((int)index, (boolean)this.lowercase));
                    } else if (this.romanNumbered) {
                        sbuf.append(RomanNumberFactory.getString((int)index, (boolean)this.lowercase));
                    } else {
                        sbuf.append(index);
                    }
                    sbuf.append(this.postSymbol);
                    li.setListSymbol(sbuf.toString(), symbolFont, lineHeight, lineHeightProportional);
                } else {
                    li.setListSymbol(this.symbol.getContent(), symbolFont, lineHeight, lineHeightProportional);
                }
            } else {
                li.setListSymbol("", symbolFont, lineHeight, lineHeightProportional);
            }
            li.setIndentationLeft(this.symbolIndent);
            li.setIndentationRight(0.0f);
            this.list.add(li);
        } else if (element instanceof com.itextpdf.text.List) {
            com.itextpdf.text.List l = (com.itextpdf.text.List)element;
            l.setIndentationLeft(l.getIndentationLeft() - this.getIndentationLeft());
            --this.first;
            this.list.add(l);
        }
    }

    public static StyleListProperties getListProperties(Map<Integer, StyleListProperties> listPropertiesMap, int level) {
        StyleListProperties listProperties = null;
        for (int i = level; i >= 0 && listProperties == null; --i) {
            listProperties = listPropertiesMap.get(i);
        }
        return listProperties;
    }

    @Override
    public void applyStyles(Style style) {
        StyleListProperties listProperties;
        this.lastStyleApplied = style;
        Map<Integer, StyleListProperties> listPropertiesMap = style.getListPropertiesMap();
        if (listPropertiesMap != null && (listProperties = StylableList.getListProperties(listPropertiesMap, this.listLevel)) != null) {
            Image image;
            String bulletChar = listProperties.getBulletChar();
            if (bulletChar != null) {
                Font font;
                Chunk symbol = new Chunk(bulletChar);
                StyleTextProperties textProperties = listProperties.getTextProperties();
                if (textProperties != null && (font = textProperties.getFont()) != null) {
                    symbol.setFont(font);
                }
                super.setListSymbol(symbol);
            }
            if ((image = listProperties.getImage()) != null) {
                Float height;
                Float width = listProperties.getWidth();
                if (width != null) {
                    image.scaleAbsoluteWidth(width.floatValue());
                }
                if ((height = listProperties.getHeight()) != null) {
                    image.scaleAbsoluteHeight(height.floatValue());
                }
                super.setListSymbol(new Chunk(image, 0.0f, 0.0f));
            }
            if (bulletChar == null && image == null) {
                StyleNumFormat numFormat;
                Integer startValue;
                Font font;
                Chunk symbol = new Chunk("");
                StyleTextProperties textProperties = listProperties.getTextProperties();
                if (textProperties != null && (font = textProperties.getFont()) != null) {
                    symbol.setFont(font);
                }
                if ((startValue = listProperties.getStartValue()) != null) {
                    super.setFirst(startValue.intValue());
                }
                if ((numFormat = listProperties.getNumFormat()) != null) {
                    String numSuffix;
                    String numPrefix = listProperties.getNumPrefix();
                    if (numPrefix != null) {
                        super.setPreSymbol(numPrefix);
                        symbol = new Chunk(numPrefix, symbol.getFont());
                    }
                    if ((numSuffix = listProperties.getNumSuffix()) != null) {
                        super.setPostSymbol(numSuffix);
                        symbol.append(numSuffix);
                    }
                    super.setNumbered(true);
                    super.setLettered(numFormat.isAlphabetical());
                    this.romanNumbered = numFormat.isRoman();
                    super.setLowercase(numFormat.isLowercase());
                }
                super.setListSymbol(symbol);
            }
            Float marginLeft = listProperties.getMarginLeft();
            Float textIndent = listProperties.getTextIndent();
            Float spaceBefore = listProperties.getSpaceBefore();
            Float minLabelWidth = listProperties.getMinLabelWidth();
            if (marginLeft != null && textIndent != null) {
                super.setIndentationLeft(Math.max(marginLeft.floatValue() + textIndent.floatValue(), 0.0f));
                super.setSymbolIndent(Math.max(-textIndent.floatValue(), 0.0f));
            } else if (spaceBefore != null && minLabelWidth != null) {
                super.setIndentationLeft(Math.max(spaceBefore.floatValue(), 0.0f));
                super.setSymbolIndent(Math.max(minLabelWidth.floatValue(), 0.0f));
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this;
    }
}

