/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.styles;

import com.itextpdf.text.BaseColor;
import fr.opensagres.odfdom.converter.core.utils.ODFUtils;
import fr.opensagres.odfdom.converter.pdf.internal.ColorRegistry;
import fr.opensagres.xdocreport.utils.BorderType;

public class StyleBorder {
    private final BorderType borderType;
    private boolean noBorder = false;
    private BaseColor color;
    private Float width;

    public StyleBorder(String border, BorderType borderType) {
        this.borderType = borderType;
        this.noBorder = "none".equals(border);
        if (this.noBorder) {
            return;
        }
        String[] s = border.split(" ");
        block4: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.width = ODFUtils.getDimensionAsPoint((String)s[i]);
                    continue block4;
                }
                case 2: {
                    this.color = ColorRegistry.getInstance().getColor(s[i]);
                }
            }
        }
    }

    public BaseColor getColor() {
        return this.color;
    }

    public void setColor(BaseColor color) {
        this.color = color;
    }

    public Float getWidth() {
        return this.width;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public boolean isNoBorder() {
        return this.noBorder;
    }

    public BorderType getBorderType() {
        return this.borderType;
    }
}

