/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import fr.opensagres.odfdom.converter.core.Color;
import fr.opensagres.odfdom.converter.core.ElementVisitorConverter;
import fr.opensagres.odfdom.converter.core.ODFConverterException;
import fr.opensagres.odfdom.converter.core.utils.ODFUtils;
import fr.opensagres.odfdom.converter.pdf.Converter;
import fr.opensagres.odfdom.converter.pdf.PdfAOptions;
import fr.opensagres.odfdom.converter.pdf.PdfOptions;
import fr.opensagres.odfdom.converter.pdf.internal.StyleEngineForIText;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableElement;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableAnchor;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableChunk;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableDocument;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableDocumentSection;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableHeaderFooter;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableHeading;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableImage;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableList;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableListItem;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableMasterPage;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableParagraph;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableParagraphWrapper;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylablePhrase;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableTab;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableTable;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableTableCell;
import fr.opensagres.odfdom.converter.pdf.internal.styles.Style;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleTextProperties;
import fr.opensagres.xdocreport.itext.extension.IMasterPage;
import fr.opensagres.xdocreport.utils.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCustomShapeElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterLeftElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderLeftElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgDescElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgTitleElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextBookmarkElement;
import org.odftoolkit.odfdom.dom.element.text.TextBookmarkStartElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexBodyElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextPageCountElement;
import org.odftoolkit.odfdom.dom.element.text.TextPageNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.dom.element.text.TextSoftPageBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableOfContentElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableOfContentSourceElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ElementVisitorForIText
extends ElementVisitorConverter {
    private final StyleEngineForIText styleEngine;
    private IStylableContainer currentContainer;
    private StylableMasterPage currentMasterPage;
    private StylableDocument document;
    private boolean parseOfficeTextElement = false;
    private boolean inTableOfContent;
    private List<Integer> currentHeadingNumbering;
    private StylableTable currentTable;
    private int currentListLevel;
    private StylableList previousList;
    private Integer forcedPageCount;
    private Integer expectedPageCount;

    public ElementVisitorForIText(OdfDocument odfDocument, OutputStream out, StyleEngineForIText styleEngine, PdfOptions options, Integer forcedPageCount) {
        super(odfDocument, options.getExtractor(), out, null);
        this.styleEngine = styleEngine;
        this.forcedPageCount = forcedPageCount;
        try {
            this.document = new StylableDocument(out, options.getConfiguration(), styleEngine);
        }
        catch (DocumentException e) {
            throw new ODFConverterException((Throwable)e);
        }
    }

    public ElementVisitorForIText(OdfDocument odfDocument, OutputStream out, StyleEngineForIText styleEngine, PdfAOptions options, Integer forcedPageCount) {
        super(odfDocument, options.getExtractor(), out, null);
        this.styleEngine = styleEngine;
        this.forcedPageCount = forcedPageCount;
        try {
            this.document = new StylableDocument(out, options.getPdfAConfiguration(), styleEngine);
        }
        catch (DocumentException e) {
            throw new ODFConverterException((Throwable)e);
        }
    }

    public Integer getExpectedPageCount() {
        return this.expectedPageCount;
    }

    public int getActualPageCount() {
        if (this.document.isOpen()) {
            return this.document.getPageNumber();
        }
        return this.document.getPageNumber() - 1;
    }

    public void visit(StyleMasterPageElement ele) {
        String name = ele.getStyleNameAttribute();
        String pageLayoutName = ele.getStylePageLayoutNameAttribute();
        String nextStyleName = ele.getStyleNextStyleNameAttribute();
        this.currentMasterPage = new StylableMasterPage(name, pageLayoutName, nextStyleName);
        this.document.addMasterPage((IMasterPage)this.currentMasterPage);
        super.visit(ele);
        this.currentMasterPage = null;
    }

    public void visit(StyleHeaderElement ele) {
        StylableHeaderFooter header = this.document.createHeaderFooter(true);
        Style style = this.document.getStyleMasterPage(this.currentMasterPage);
        if (style != null) {
            this.document.applyStyles(style);
            header.applyStyles(style);
        }
        this.currentMasterPage.setHeader(header);
        StylableTableCell tableCell = header.getTableCell();
        this.currentContainer = tableCell;
        super.visit(ele);
        header.flush();
        this.currentContainer = null;
    }

    public void visit(StyleHeaderLeftElement ele) {
    }

    public void visit(StyleFooterElement ele) {
        StylableHeaderFooter footer = this.document.createHeaderFooter(false);
        Style style = this.document.getStyleMasterPage(this.currentMasterPage);
        if (style != null) {
            this.document.applyStyles(style);
            footer.applyStyles(style);
        }
        this.currentMasterPage.setFooter(footer);
        StylableTableCell tableCell = footer.getTableCell();
        this.currentContainer = tableCell;
        super.visit(ele);
        footer.flush();
        this.currentContainer = null;
    }

    public void visit(StyleFooterLeftElement ele) {
    }

    public void visit(OfficeTextElement ele) {
        this.parseOfficeTextElement = true;
        this.currentContainer = this.document;
        super.visit(ele);
        this.parseOfficeTextElement = false;
    }

    public void visit(TextTableOfContentElement ele) {
        this.inTableOfContent = true;
        super.visit(ele);
        this.inTableOfContent = false;
    }

    public void visit(TextTableOfContentSourceElement ele) {
    }

    public void visit(TextIndexBodyElement ele) {
        super.visit(ele);
    }

    public void visit(TextSectionElement ele) {
        StylableDocumentSection documentSection = this.document.createDocumentSection(this.currentContainer, !this.parseOfficeTextElement);
        this.applyStyles((OdfElement)ele, documentSection);
        this.addITextContainer((OdfElement)ele, documentSection);
    }

    public void visit(TextHElement ele) {
        int outlineLevel;
        int n = outlineLevel = ele.getTextOutlineLevelAttribute() != null ? ele.getTextOutlineLevelAttribute() : 1;
        if (this.currentHeadingNumbering == null) {
            this.currentHeadingNumbering = new ArrayList<Integer>();
        }
        while (this.currentHeadingNumbering.size() > outlineLevel) {
            this.currentHeadingNumbering.remove(this.currentHeadingNumbering.size() - 1);
        }
        if (this.currentHeadingNumbering.size() == outlineLevel) {
            this.currentHeadingNumbering.set(outlineLevel - 1, this.currentHeadingNumbering.get(outlineLevel - 1) + 1);
        }
        while (this.currentHeadingNumbering.size() < outlineLevel) {
            this.currentHeadingNumbering.add(StylableHeading.getFirst(this.currentContainer.getLastStyleApplied(), this.currentHeadingNumbering.size() + 1));
        }
        this.processParagraphOrHeading((TextParagraphElementBase)ele, new ArrayList<Integer>(this.currentHeadingNumbering));
    }

    public void visit(TextPElement ele) {
        this.processParagraphOrHeading((TextParagraphElementBase)ele, null);
    }

    private void processParagraphOrHeading(TextParagraphElementBase ele, List<Integer> headingNumbering) {
        StylableParagraphWrapper paragraphWrapper = this.createParagraphWrapperAndApplyStyles(ele);
        if (paragraphWrapper.hasBorders() || paragraphWrapper.hasBackgroundColor()) {
            boolean joinWithPrevious = this.joinParagraphWith(paragraphWrapper, ele.getPreviousSibling());
            boolean joinWithNext = this.joinParagraphWith(paragraphWrapper, ele.getNextSibling());
            if (!joinWithPrevious) {
                this.currentContainer = paragraphWrapper;
            }
            StylableParagraph paragraph = headingNumbering != null ? this.document.createHeading(this.currentContainer, headingNumbering) : this.document.createParagraph(this.currentContainer);
            this.applyStyles((OdfElement)ele, paragraph);
            if (joinWithNext) {
                paragraph.setSpacingAfter((Paragraph)paragraphWrapper);
            }
            if (joinWithPrevious) {
                paragraph.setSpacingBefore((Paragraph)paragraphWrapper);
            }
            this.addITextContainer((OdfElement)ele, paragraph);
            if (!joinWithNext) {
                IStylableContainer oldContainer = this.currentContainer.getParent();
                oldContainer.addElement(this.currentContainer.getElement());
                this.currentContainer = oldContainer;
            }
        } else {
            StylableParagraph paragraph = headingNumbering != null ? this.document.createHeading(this.currentContainer, headingNumbering) : this.document.createParagraph(this.currentContainer);
            this.applyStyles((OdfElement)ele, paragraph);
            paragraph.setIndentation((Paragraph)paragraphWrapper);
            paragraph.setSpacingBefore((Paragraph)paragraphWrapper);
            paragraph.setSpacingAfter((Paragraph)paragraphWrapper);
            this.addITextContainer((OdfElement)ele, paragraph);
        }
    }

    private StylableParagraphWrapper createParagraphWrapperAndApplyStyles(TextParagraphElementBase ele) {
        StylableParagraphWrapper paragraphWrapper = new StylableParagraphWrapper(this.document, this.currentContainer);
        this.applyStyles((OdfElement)ele, paragraphWrapper);
        return paragraphWrapper;
    }

    private boolean joinParagraphWith(StylableParagraphWrapper paragraphWrapper1, Node node) {
        if (node instanceof TextParagraphElementBase) {
            TextParagraphElementBase ele = (TextParagraphElementBase)node;
            StylableParagraphWrapper paragraphWrapper2 = this.createParagraphWrapperAndApplyStyles(ele);
            Style style1 = paragraphWrapper1.getLastStyleApplied();
            Style style2 = paragraphWrapper2.getLastStyleApplied();
            if (style1 != null && style2 != null) {
                String styleName1 = style1.getStyleName();
                String styleName2 = style2.getStyleName();
                if (styleName1 != null && styleName1.equals(styleName2)) {
                    boolean hasBorders = paragraphWrapper1.hasBorders();
                    boolean joinBorder = paragraphWrapper1.joinBorder();
                    if (hasBorders && joinBorder) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void visit(TextSpanElement ele) {
        StylablePhrase phrase = this.document.createPhrase(this.currentContainer);
        this.applyStyles((OdfElement)ele, phrase);
        this.addITextContainer((OdfElement)ele, phrase);
    }

    public void visit(TextAElement ele) {
        StylableAnchor anchor = this.document.createAnchor(this.currentContainer);
        String reference = ele.getXlinkHrefAttribute();
        this.applyStyles((OdfElement)ele, anchor);
        if (anchor.getFont().getColor() == null) {
            Font font;
            StyleTextProperties textProperties;
            Font linkFont = anchor.getFont();
            Style style = this.currentContainer.getLastStyleApplied();
            if (style != null && (textProperties = style.getTextProperties()) != null && (font = textProperties.getFont()) != null) {
                linkFont = new Font(font);
                anchor.setFont(linkFont);
            }
            linkFont.setColor(Converter.toBaseColor(Color.BLUE));
        }
        if (reference.endsWith("|outline")) {
            reference = "#" + StylableHeading.generateImplicitDestination(reference);
        }
        anchor.setReference(reference);
        this.addITextContainer((OdfElement)ele, anchor);
    }

    public void visit(TextBookmarkElement ele) {
        this.createAndAddChunk("\t", ele.getTextNameAttribute(), false);
    }

    public void visit(TextBookmarkStartElement ele) {
        this.createAndAddChunk("\t", ele.getTextNameAttribute(), false);
        super.visit(ele);
    }

    public void visit(TableTableElement ele) {
        float[] columnWidth = ODFUtils.getColumnWidths((TableTableElement)ele, (OdfDocument)this.odfDocument);
        StylableTable table = this.document.createTable(this.currentContainer, columnWidth.length);
        try {
            table.setTotalWidth(columnWidth);
        }
        catch (DocumentException e) {
            // empty catch block
        }
        this.applyStyles((OdfElement)ele, table);
        StylableTable oldTable = this.currentTable;
        this.currentTable = table;
        this.addITextContainer((OdfElement)ele, table);
        this.currentTable = oldTable;
    }

    public void visit(TableTableHeaderRowsElement ele) {
        this.currentTable.beginTableHeaderRows();
        super.visit(ele);
        this.currentTable.endTableHeaderRows();
    }

    public void visit(TableTableRowElement ele) {
        Style currentRowStyle = this.getStyle((OdfElement)ele, null);
        if (currentRowStyle != null) {
            this.currentTable.applyStyles(currentRowStyle);
        }
        this.currentTable.beginTableRow(currentRowStyle);
        super.visit(ele);
        this.currentTable.endTableRow();
    }

    public void visit(TableTableCellElement ele) {
        Integer rowSpan;
        StylableTableCell tableCell = this.document.createTableCell(this.currentContainer);
        Integer colSpan = ele.getTableNumberColumnsSpannedAttribute();
        if (colSpan != null) {
            tableCell.setColspan(colSpan);
        }
        if ((rowSpan = ele.getTableNumberRowsSpannedAttribute()) != null) {
            tableCell.setRowspan(rowSpan);
        }
        if (this.currentTable.getCurrentRowStyle() != null) {
            tableCell.applyStyles(this.currentTable.getCurrentRowStyle());
        }
        this.applyStyles((OdfElement)ele, tableCell);
        this.addITextContainer((OdfElement)ele, tableCell);
    }

    public void visit(TextListElement ele) {
        ++this.currentListLevel;
        StylableList list = this.document.createList(this.currentContainer, this.currentListLevel);
        this.applyStyles((OdfElement)ele, list);
        Boolean continueNumbering = ele.getTextContinueNumberingAttribute();
        if (Boolean.TRUE.equals(continueNumbering) && this.previousList != null && this.previousList.getLastStyleApplied() != null && list.getLastStyleApplied() != null && this.previousList.getLastStyleApplied().getStyleName() != null && this.previousList.getLastStyleApplied().getStyleName().equals(list.getLastStyleApplied().getStyleName())) {
            list.setFirst(this.previousList.getIndex());
        }
        this.addITextContainer((OdfElement)ele, list);
        --this.currentListLevel;
        this.previousList = list;
    }

    public void visit(TextListItemElement ele) {
        StylableListItem listItem = this.document.createListItem(this.currentContainer);
        this.addITextContainer((OdfElement)ele, listItem);
    }

    protected void visitImage(DrawImageElement ele, String href, byte[] imageStream) {
        Image imageObj = StylableImage.getImage(imageStream);
        if (imageObj != null) {
            DrawFrameElement frame = null;
            Float x = null;
            Float y = null;
            Float width = null;
            Float height = null;
            Node parentNode = ele.getParentNode();
            if (parentNode instanceof DrawFrameElement) {
                String svgHeight;
                String svgWidth;
                String svgY;
                frame = (DrawFrameElement)parentNode;
                String svgX = frame.getSvgXAttribute();
                if (StringUtils.isNotEmpty((String)svgX)) {
                    x = ODFUtils.getDimensionAsPoint((String)svgX);
                }
                if (StringUtils.isNotEmpty((String)(svgY = frame.getSvgYAttribute()))) {
                    y = ODFUtils.getDimensionAsPoint((String)svgY);
                }
                if (StringUtils.isNotEmpty((String)(svgWidth = frame.getSvgWidthAttribute()))) {
                    width = ODFUtils.getDimensionAsPoint((String)svgWidth);
                }
                if (StringUtils.isNotEmpty((String)(svgHeight = frame.getSvgHeightAttribute()))) {
                    height = ODFUtils.getDimensionAsPoint((String)svgHeight);
                }
            }
            StylableImage image = this.document.createImage(this.currentContainer, imageObj, x, y, width, height);
            if (frame != null) {
                this.applyStyles((OdfElement)frame, image);
            }
            this.addITextElement(image);
        }
    }

    protected boolean isNeedImageStream() {
        return true;
    }

    public void visit(DrawTextBoxElement ele) {
    }

    public void visit(DrawLineElement ele) {
    }

    public void visit(DrawCustomShapeElement ele) {
    }

    public void visit(SvgTitleElement ele) {
    }

    public void visit(SvgDescElement ele) {
    }

    public void visit(TextSoftPageBreakElement ele) {
    }

    public void visit(TextTabElement ele) {
        StylableTab tab = this.document.createTab(this.currentContainer, this.inTableOfContent);
        Style style = this.currentContainer.getLastStyleApplied();
        if (style != null) {
            tab.applyStyles(style);
        }
        this.addITextElement(tab);
    }

    public void visit(TextLineBreakElement ele) {
        this.createAndAddChunk("\n", null, false);
    }

    public void visit(TextSElement ele) {
        String spaceStr = " ";
        Integer spaceCount = ele.getTextCAttribute();
        if (spaceCount != null && spaceCount > 1) {
            for (int i = 1; i < spaceCount; ++i) {
                spaceStr = spaceStr + " ";
            }
        }
        this.createAndAddChunk(spaceStr, null, false);
    }

    public void visit(TextPageNumberElement ele) {
        this.createAndAddChunk("#", null, true);
    }

    public void visit(TextPageCountElement ele) {
        if (this.forcedPageCount != null) {
            this.createAndAddChunk(this.forcedPageCount.toString(), null, false);
        } else {
            String textContent = ele.getTextContent();
            try {
                int pageCount = Integer.parseInt(textContent);
                if (this.expectedPageCount == null || this.expectedPageCount == pageCount) {
                    this.expectedPageCount = pageCount;
                } else if (this.expectedPageCount != pageCount) {
                    this.expectedPageCount = -1;
                }
            }
            catch (NumberFormatException e) {
                this.expectedPageCount = -1;
            }
            textContent = this.expectedPageCount != null & this.expectedPageCount >= 0 ? this.expectedPageCount.toString() : "#";
            this.createAndAddChunk(textContent, null, false);
        }
    }

    protected void processTextNode(Text node) {
        this.createAndAddChunk(node.getTextContent(), null, false);
    }

    private void createAndAddChunk(String textContent, String localDestinationName, boolean pageNumberChunk) {
        List<StylableChunk> chunks = StylableChunk.createChunks(this.document, this.currentContainer, textContent);
        for (StylableChunk chunk : chunks) {
            Style style = this.currentContainer.getLastStyleApplied();
            if (style != null) {
                chunk.applyStyles(style);
            }
            if (localDestinationName != null) {
                chunk.setLocalDestination(localDestinationName);
            }
            if (pageNumberChunk) {
                chunk.setPageNumberChunk(pageNumberChunk);
            }
            this.addITextElement(chunk);
        }
    }

    public void save() throws IOException {
        if (this.document != null) {
            this.document.close();
        }
        super.save();
    }

    private void addITextContainer(OdfElement ele, IStylableContainer newContainer) {
        this.addITextContainer(ele, newContainer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addITextContainer(OdfElement ele, IStylableContainer newContainer, boolean add) {
        IStylableContainer oldContainer = this.currentContainer;
        try {
            this.currentContainer = newContainer;
            super.visit(ele);
            if (add) {
                oldContainer.addElement(newContainer.getElement());
            }
        }
        finally {
            this.currentContainer = oldContainer;
        }
    }

    private void addITextElement(IStylableElement element) {
        this.currentContainer.addElement(element.getElement());
    }

    private void applyStyles(OdfElement ele, IStylableElement element) {
        Style style = this.getStyle(ele, element);
        if (style != null) {
            if (this.parseOfficeTextElement) {
                String masterPageName = style.getMasterPageName();
                if (StringUtils.isNotEmpty((String)masterPageName)) {
                    StylableMasterPage masterPage = this.document.getMasterPage(masterPageName);
                    if (masterPage != null && masterPage != this.document.getActiveMasterPage()) {
                        this.document.setActiveMasterPage((IMasterPage)masterPage);
                    }
                } else if (this.document.getActiveMasterPage() == null) {
                    this.document.setActiveMasterPage((IMasterPage)this.document.getDefaultMasterPage());
                }
            }
            element.applyStyles(style);
        }
    }

    private Style getStyle(OdfElement e, IStylableElement element) {
        Style parentElementStyle;
        Style style = null;
        Style style2 = parentElementStyle = element != null ? this.getParentElementStyle(element) : null;
        if (e instanceof OdfStylableElement) {
            OdfStylableElement ele = (OdfStylableElement)e;
            String styleName = ele.getStyleName();
            String familyName = ele.getStyleFamily() != null ? ele.getStyleFamily().getName() : null;
            style = this.styleEngine.getStyle(familyName, styleName, parentElementStyle);
        } else if (e instanceof TextListElement) {
            TextListElement ele = (TextListElement)e;
            String styleName = ele.getTextStyleNameAttribute();
            style = this.styleEngine.getStyle(OdfStyleFamily.List.getName(), styleName, parentElementStyle);
        }
        return style;
    }

    private Style getParentElementStyle(IStylableElement element) {
        for (IStylableContainer c = element.getParent(); c != null; c = c.getParent()) {
            Style style = c.getLastStyleApplied();
            if (style == null) continue;
            return style;
        }
        return null;
    }
}

