/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.stylable;

import com.google.code.appengine.awt.Color;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableDocument;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StyleUtils;
import fr.opensagres.odfdom.converter.pdf.internal.styles.Style;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleBorder;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleParagraphProperties;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;

public class StylableParagraphWrapper
extends ExtendedParagraph
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private IStylableContainer parent;
    private Style lastStyleApplied = null;
    private boolean joinBorder = true;
    PdfPTable wrapperTable = null;

    public StylableParagraphWrapper(StylableDocument ownerDocument, IStylableContainer parent) {
        this.parent = parent;
    }

    public boolean joinBorder() {
        return this.joinBorder;
    }

    @Override
    public void addElement(Element element) {
        this.getWrapperCell().addElement(element);
    }

    @Override
    public void applyStyles(Style style) {
        this.lastStyleApplied = style;
        StyleParagraphProperties paragraphProperties = style.getParagraphProperties();
        if (paragraphProperties != null) {
            Boolean keepTogether;
            Boolean joinBorder;
            Float paddingBottom;
            Float paddingTop;
            Float paddingRight;
            Float paddingLeft;
            Float padding;
            StyleBorder borderBottom;
            StyleBorder borderTop;
            StyleBorder borderRight;
            StyleBorder borderLeft;
            StyleBorder border;
            Color backgroundColor;
            Float marginBottom;
            Float marginTop;
            Float marginRight;
            Float marginLeft;
            Float margin = paragraphProperties.getMargin();
            if (margin != null && margin.floatValue() > 0.0f) {
                super.setIndentationLeft(margin.floatValue());
                super.setIndentationRight(margin.floatValue());
                super.setSpacingBefore(margin.floatValue());
                super.setSpacingAfter(margin.floatValue());
            }
            if ((marginLeft = paragraphProperties.getMarginLeft()) != null && marginLeft.floatValue() > 0.0f) {
                super.setIndentationLeft(marginLeft.floatValue());
            }
            if ((marginRight = paragraphProperties.getMarginRight()) != null && marginRight.floatValue() > 0.0f) {
                super.setIndentationRight(marginRight.floatValue());
            }
            if ((marginTop = paragraphProperties.getMarginTop()) != null && marginTop.floatValue() > 0.0f) {
                super.setSpacingBefore(marginTop.floatValue());
            }
            if ((marginBottom = paragraphProperties.getMarginBottom()) != null && marginBottom.floatValue() > 0.0f) {
                super.setSpacingAfter(marginBottom.floatValue());
            }
            if ((backgroundColor = paragraphProperties.getBackgroundColor()) != null && !TRANSPARENT_COLOR.equals((Object)backgroundColor)) {
                this.getWrapperCell().setBackgroundColor(backgroundColor);
            }
            if ((border = paragraphProperties.getBorder()) != null && !border.isNoBorder()) {
                StyleUtils.applyStyles(border, this.getWrapperCell());
            }
            if ((borderLeft = paragraphProperties.getBorderLeft()) != null && !borderLeft.isNoBorder()) {
                StyleUtils.applyStyles(borderLeft, this.getWrapperCell());
            }
            if ((borderRight = paragraphProperties.getBorderRight()) != null && !borderRight.isNoBorder()) {
                StyleUtils.applyStyles(borderRight, this.getWrapperCell());
            }
            if ((borderTop = paragraphProperties.getBorderTop()) != null && !borderTop.isNoBorder()) {
                StyleUtils.applyStyles(borderTop, this.getWrapperCell());
            }
            if ((borderBottom = paragraphProperties.getBorderBottom()) != null && !borderBottom.isNoBorder()) {
                StyleUtils.applyStyles(borderBottom, this.getWrapperCell());
            }
            if ((padding = paragraphProperties.getPadding()) != null && padding.floatValue() > 0.0f) {
                if (this.getWrapperCell().hasBorder(4)) {
                    this.getWrapperCell().setPaddingLeft(padding.floatValue());
                }
                if (this.getWrapperCell().hasBorder(8)) {
                    this.getWrapperCell().setPaddingRight(padding.floatValue());
                }
                if (this.getWrapperCell().hasBorder(1)) {
                    this.getWrapperCell().setPaddingTop(padding.floatValue());
                }
                if (this.getWrapperCell().hasBorder(2)) {
                    this.getWrapperCell().setPaddingBottom(padding.floatValue());
                }
            }
            if ((paddingLeft = paragraphProperties.getPaddingLeft()) != null && paddingLeft.floatValue() > 0.0f && this.getWrapperCell().hasBorder(4)) {
                this.getWrapperCell().setPaddingLeft(paddingLeft.floatValue());
            }
            if ((paddingRight = paragraphProperties.getPaddingRight()) != null && paddingRight.floatValue() > 0.0f && this.getWrapperCell().hasBorder(8)) {
                this.getWrapperCell().setPaddingRight(paddingRight.floatValue());
            }
            if ((paddingTop = paragraphProperties.getPaddingTop()) != null && paddingTop.floatValue() > 0.0f && this.getWrapperCell().hasBorder(1)) {
                this.getWrapperCell().setPaddingTop(paddingTop.floatValue());
            }
            if ((paddingBottom = paragraphProperties.getPaddingBottom()) != null && paddingBottom.floatValue() > 0.0f && this.getWrapperCell().hasBorder(2)) {
                this.getWrapperCell().setPaddingBottom(paddingBottom.floatValue());
            }
            if ((joinBorder = paragraphProperties.getJoinBorder()) != null) {
                this.joinBorder = joinBorder;
            }
            if ((keepTogether = paragraphProperties.getKeepTogether()) != null) {
                super.setKeepTogether(keepTogether.booleanValue());
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        if (this.wrapperTable == null) {
            this.wrapperTable = this.createWrapperTable(this.getWrapperCell(), false);
        }
        return this.wrapperTable;
    }
}

