/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class SignUtil {
    public static final String H_MAC_SHA256 = "HmacSHA256";

    public static String sign(TreeMap<String, String> parameterMap, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        StringBuilder builder = new StringBuilder();
        parameterMap.forEach((key, value) -> builder.append((String)key).append((String)value));
        Mac mac = Mac.getInstance(H_MAC_SHA256);
        mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), H_MAC_SHA256));
        byte[] signData = mac.doFinal(builder.toString().getBytes(StandardCharsets.UTF_8));
        return new String(Base64.encodeBase64((byte[])signData));
    }

    public static String sign(String appKey, Long timestamp, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        return SignUtil.sign(appKey, timestamp, null, secret);
    }

    public static String sign(String appKey, Long timestamp, String code, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        parameterMap.put("appKey", appKey);
        parameterMap.put("timestamp", String.valueOf(timestamp));
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            parameterMap.put("code", code);
        }
        return SignUtil.sign(parameterMap, secret);
    }
}

