/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.connection;

import com.vladmihalcea.flexypool.connection.ConnectionCallback;
import com.vladmihalcea.flexypool.connection.ConnectionProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;

public class JdkConnectionProxyFactory
extends ConnectionProxyFactory {
    public static final ConnectionProxyFactory INSTANCE = new JdkConnectionProxyFactory();

    @Override
    protected Connection proxyConnection(Connection target, ConnectionCallback callback) {
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(target, callback));
    }

    private static class ConnectionInvocationHandler
    implements InvocationHandler {
        public static final String CLOSE_METHOD_NAME = "close";
        private final Connection target;
        private final ConnectionCallback callback;

        public ConnectionInvocationHandler(Connection target, ConnectionCallback callback) {
            this.target = target;
            this.callback = callback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (CLOSE_METHOD_NAME.equals(method.getName())) {
                this.callback.close();
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

