/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.connection;

import com.vladmihalcea.flexypool.connection.ConnectionDecoratorFactory;
import com.vladmihalcea.flexypool.connection.ConnectionDecoratorFactoryService;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionDecoratorFactoryResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionDecoratorFactoryResolver.class);
    public static final ConnectionDecoratorFactoryResolver INSTANCE = new ConnectionDecoratorFactoryResolver();
    private ServiceLoader<ConnectionDecoratorFactoryService> serviceLoader = ServiceLoader.load(ConnectionDecoratorFactoryService.class);

    private ConnectionDecoratorFactoryResolver() {
    }

    public ConnectionDecoratorFactory resolve() {
        int loadingIndex = Integer.MIN_VALUE;
        ConnectionDecoratorFactory connectionDecoratorFactory = null;
        Iterator<ConnectionDecoratorFactoryService> connectionDecoratorFactoryServiceIterator = this.serviceLoader.iterator();
        while (connectionDecoratorFactoryServiceIterator.hasNext()) {
            try {
                ConnectionDecoratorFactory currentConnectionDecoratorFactory;
                ConnectionDecoratorFactoryService connectionDecoratorFactoryService = connectionDecoratorFactoryServiceIterator.next();
                int currentLoadingIndex = connectionDecoratorFactoryService.loadingIndex();
                if (currentLoadingIndex <= loadingIndex || (currentConnectionDecoratorFactory = connectionDecoratorFactoryService.load()) == null) continue;
                connectionDecoratorFactory = currentConnectionDecoratorFactory;
                loadingIndex = currentLoadingIndex;
            }
            catch (LinkageError e) {
                LOGGER.info("Couldn't load ConnectionDecoratorFactoryService on the current JVM", (Throwable)e);
            }
        }
        if (connectionDecoratorFactory != null) {
            return connectionDecoratorFactory;
        }
        throw new IllegalStateException("No ConnectionDecoratorFactory could be loaded!");
    }
}

