/*
 * Decompiled with CFR 0.152.
 */
package com.twitter;

import com.google.common.base.Join;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.twitter.ScroogeRunner;
import com.twitter.ThriftNamespaceMapping;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

abstract class AbstractMavenScroogeMojo
extends AbstractMojo {
    private static final String THRIFT_FILE_SUFFIX = ".thrift";
    private static final String DEFAULT_INCLUDES = "**/*.thrift";
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    private Set<File> thriftIncludes = new HashSet<File>();
    private String language;
    private Set<String> thriftOpts = new HashSet<String>();
    private Set<String> dependencyConfig = new HashSet<String>();
    private Set<ThriftNamespaceMapping> thriftNamespaceMappings = new HashSet<ThriftNamespaceMapping>();
    private Set<String> includes = ImmutableSet.of((Object)"**/*.thrift");
    private Set<String> excludes = ImmutableSet.of();
    private boolean fixHashcode = false;
    private boolean checkStaleness = true;
    private long staleMillis = 0L;
    private static Object lock = new Object();

    AbstractMavenScroogeMojo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block8: {
            try {
                Set<File> thriftFiles = this.findThriftFiles();
                File outputDirectory = this.getOutputDirectory();
                ImmutableSet<File> outputFiles = this.findGeneratedFilesInDirectory(this.getOutputDirectory());
                HashSet<String> compileRoots = new HashSet<String>();
                compileRoots.add("scrooge");
                if (thriftFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No thrift files to compile.");
                    break block8;
                }
                if (this.checkStaleness && this.lastModified(thriftFiles) + this.staleMillis < this.lastModified((Set<File>)outputFiles)) {
                    this.getLog().info((CharSequence)"Generated thrift files up to date, skipping compile.");
                    this.attachFiles(compileRoots);
                    break block8;
                }
                outputDirectory.mkdirs();
                FileUtils.cleanDirectory((File)outputDirectory);
                this.getLog().info((CharSequence)String.format("compiling thrift files %s with Scrooge", thriftFiles));
                Object object = lock;
                synchronized (object) {
                    ScroogeRunner runner = new ScroogeRunner();
                    HashMap<String, String> thriftNamespaceMap = new HashMap<String, String>();
                    for (ThriftNamespaceMapping mapping : this.thriftNamespaceMappings) {
                        thriftNamespaceMap.put(mapping.getFrom(), mapping.getTo());
                    }
                    Set<File> includes = this.thriftIncludes;
                    includes.add(this.getResourcesOutputDirectory());
                    runner.compile(this.getLog(), new File(outputDirectory, "scrooge"), thriftFiles, includes, thriftNamespaceMap, this.language, this.thriftOpts);
                }
                this.attachFiles(compileRoots);
            }
            catch (IOException e) {
                throw new MojoExecutionException("An IO error occured", (Exception)e);
            }
        }
    }

    protected abstract File getThriftSourceRoot();

    protected abstract File getOutputDirectory();

    protected abstract File getResourcesOutputDirectory();

    protected abstract void attachFiles(Set<String> var1);

    protected abstract String getDependencyScopeFilter();

    protected abstract List<File> getReferencedThriftFiles() throws IOException;

    private long lastModified(Set<File> files) {
        long result = 0L;
        for (File file : files) {
            if (file.lastModified() <= result) continue;
            result = file.lastModified();
        }
        return result;
    }

    private Set<File> findThriftFiles() throws IOException {
        File thriftSourceRoot = this.getThriftSourceRoot();
        HashSet<File> thriftFiles = new HashSet<File>();
        if (thriftSourceRoot != null && thriftSourceRoot.exists()) {
            thriftFiles.addAll((Collection<File>)this.findThriftFilesInDirectory(thriftSourceRoot));
        }
        this.getLog().info((CharSequence)"finding thrift files in dependencies");
        this.extractFilesFromDependencies(this.findThriftDependencies(this.dependencyConfig), this.getResourcesOutputDirectory());
        if (this.getResourcesOutputDirectory().exists()) {
            thriftFiles.addAll((Collection<File>)this.findThriftFilesInDirectory(this.getResourcesOutputDirectory()));
        }
        this.getLog().info((CharSequence)"finding thrift files in referenced (reactor) projects");
        thriftFiles.addAll(this.getReferencedThriftFiles());
        return thriftFiles;
    }

    private Set<Artifact> findThriftDependencies(Set<String> whitelist) throws IOException {
        HashSet<Artifact> thriftDependencies = new HashSet<Artifact>();
        HashSet allDependencies = new HashSet();
        allDependencies.addAll(this.project.getArtifacts());
        allDependencies.addAll(this.project.getDependencyArtifacts());
        for (Artifact artifact : allDependencies) {
            String artifactId = artifact.getArtifactId();
            if (!whitelist.contains(artifactId)) continue;
            thriftDependencies.add(artifact);
        }
        return thriftDependencies;
    }

    private void extractFilesFromDependencies(Collection<Artifact> dependencies, File output) throws IOException {
        for (Artifact artifact : dependencies) {
            File dep = artifact.getFile();
            this.getLog().info((CharSequence)("extracting thrift files from " + dep.getCanonicalPath()));
            File destFolder = new File(output, artifact.getArtifactId());
            destFolder.mkdirs();
            if (dep.isFile() && dep.canRead() && dep.getName().endsWith(".jar")) {
                JarFile jar = new JarFile(dep);
                for (JarEntry entry : Collections.list(jar.entries())) {
                    if (!entry.getName().endsWith(THRIFT_FILE_SUFFIX)) continue;
                    File destination = new File(destFolder, entry.getName());
                    this.getLog().info((CharSequence)String.format("extracting %s to %s", entry.getName(), destination.getCanonicalPath()));
                    FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(jar.getInputStream(entry)), (File)destination);
                    if (destination.setLastModified(dep.lastModified())) continue;
                    this.getLog().warn((CharSequence)String.format("fail to set last modified time for %s", destination.getCanonicalPath()));
                }
                continue;
            }
            this.getLog().warn((CharSequence)String.format("dep %s isn't a file or can't be read", dep.getCanonicalPath()));
        }
    }

    private ImmutableSet<File> findGeneratedFilesInDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            return ImmutableSet.of();
        }
        List sourceFilesInDirectory = FileUtils.getFiles((File)directory, (String)"**/*.java", null);
        sourceFilesInDirectory.addAll(FileUtils.getFiles((File)directory, (String)"**/*.scala", null));
        return ImmutableSet.copyOf((Iterable)sourceFilesInDirectory);
    }

    private ImmutableSet<File> findThriftFilesInDirectory(File directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"%s is not a directory", (Object[])new Object[]{directory});
        List thriftFilesInDirectory = FileUtils.getFiles((File)directory, (String)Join.join((String)",", this.includes), (String)Join.join((String)",", this.excludes));
        return ImmutableSet.copyOf((Iterable)thriftFilesInDirectory);
    }

    protected List<File> getRecursiveThriftFiles(MavenProject project, String outputDirectory) throws IOException {
        return this.getRecursiveThriftFiles(project, outputDirectory, new ArrayList<File>());
    }

    List<File> getRecursiveThriftFiles(MavenProject project, String outputDirectory, List<File> files) throws IOException {
        File dir;
        if (this.dependencyConfig.contains(project.getArtifactId()) && (dir = new File(new File(project.getFile().getParent(), "target"), outputDirectory)).exists()) {
            try {
                URI baseDir = new URI("file://" + dir.getCanonicalPath());
                for (File f : this.findThriftFilesInDirectory(dir)) {
                    URI fileURI = new URI("file://" + f.getCanonicalPath());
                    String relPath = baseDir.relativize(fileURI).getPath();
                    File destFolder = new File(this.getResourcesOutputDirectory(), project.getArtifactId());
                    destFolder.mkdirs();
                    File destFile = new File(destFolder, relPath);
                    this.getLog().info((CharSequence)String.format("copying %s to %s", f.getCanonicalPath(), destFile.getCanonicalPath()));
                    FileUtils.copyFile((File)f, (File)destFile);
                    files.add(destFile);
                }
            }
            catch (URISyntaxException urie) {
                throw new IOException("error forming URI for file transfer: " + urie);
            }
        }
        Map refs = project.getProjectReferences();
        for (String name : refs.keySet()) {
            this.getRecursiveThriftFiles((MavenProject)refs.get(name), outputDirectory, files);
        }
        return files;
    }
}

