/*
 * Decompiled with CFR 0.152.
 */
package parquet.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import parquet.Log;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class MessageTypeParser {
    private static final Log LOG = Log.getLog(MessageTypeParser.class);

    private MessageTypeParser() {
    }

    public static MessageType parseMessageType(String input) {
        return MessageTypeParser.parse(input);
    }

    private static MessageType parse(String schemaString) {
        Tokenizer st = new Tokenizer(schemaString, " ;{}()\n\t");
        String t = st.nextToken();
        MessageTypeParser.check(t, "message", "start with 'message'", st);
        String name = st.nextToken();
        Type[] fields = MessageTypeParser.readGroupTypeFields(st.nextToken(), st);
        return new MessageType(name, fields);
    }

    private static Type[] readGroupTypeFields(String t, Tokenizer st) {
        ArrayList<Type> types = new ArrayList<Type>();
        MessageTypeParser.check(t, "{", "start of message", st);
        while (!(t = st.nextToken()).equals("}")) {
            types.add(MessageTypeParser.readType(t, st));
        }
        return types.toArray(new Type[types.size()]);
    }

    private static Type readType(String t, Tokenizer st) {
        Type.Repetition r = MessageTypeParser.asRepetition(t, st);
        String type = st.nextToken();
        int typeLength = 0;
        if (type.equalsIgnoreCase("fixed_len_byte_array")) {
            t = st.nextToken();
            if (!t.equalsIgnoreCase("(")) {
                throw new IllegalArgumentException("expecting (length) for field of type fixed_len_byte_array");
            }
            typeLength = Integer.parseInt(st.nextToken());
            MessageTypeParser.check(st.nextToken(), ")", "type length ended by )", st);
        }
        String name = st.nextToken();
        t = st.nextToken();
        OriginalType originalType = null;
        if (t.equalsIgnoreCase("(")) {
            originalType = OriginalType.valueOf(st.nextToken());
            MessageTypeParser.check(st.nextToken(), ")", "original type ended by )", st);
            t = st.nextToken();
        }
        try {
            if (type.equalsIgnoreCase("group")) {
                Type[] fields = MessageTypeParser.readGroupTypeFields(t, st);
                return new GroupType(r, name, originalType, fields);
            }
            PrimitiveType.PrimitiveTypeName p = MessageTypeParser.asPrimitive(type, st);
            MessageTypeParser.check(t, ";", "field ended by ';'", st);
            return new PrimitiveType(r, p, typeLength, name, originalType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("problem reading type: type = " + type + ", name = " + name + ", original type = " + (Object)((Object)originalType), e);
        }
    }

    private static PrimitiveType.PrimitiveTypeName asPrimitive(String t, Tokenizer st) {
        try {
            return PrimitiveType.PrimitiveTypeName.valueOf(t.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])PrimitiveType.PrimitiveTypeName.values()) + " got " + t + " at " + st.getLocationString(), e);
        }
    }

    private static Type.Repetition asRepetition(String t, Tokenizer st) {
        try {
            return Type.Repetition.valueOf(t.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])Type.Repetition.values()) + " got " + t + " at " + st.getLocationString(), e);
        }
    }

    private static void check(String t, String expected, String message, Tokenizer tokenizer) {
        if (!t.equalsIgnoreCase(expected)) {
            throw new IllegalArgumentException(message + ": expected '" + expected + "' but got '" + t + "' at " + tokenizer.getLocationString());
        }
    }

    private static class Tokenizer {
        private StringTokenizer st;
        private int line = 0;
        private StringBuffer currentLine = new StringBuffer();

        public Tokenizer(String schemaString, String string) {
            this.st = new StringTokenizer(schemaString, " ;{}()\n\t", true);
        }

        public String nextToken() {
            while (this.st.hasMoreTokens()) {
                String t = this.st.nextToken();
                if (t.equals("\n")) {
                    ++this.line;
                    this.currentLine.setLength(0);
                } else {
                    this.currentLine.append(t);
                }
                if (this.isWhitespace(t)) continue;
                return t;
            }
            throw new IllegalArgumentException("unexpected end of schema");
        }

        private boolean isWhitespace(String t) {
            return t.equals(" ") || t.equals("\t") || t.equals("\n");
        }

        public String getLocationString() {
            return "line " + this.line + ": " + this.currentLine.toString();
        }
    }
}

