/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.api;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.server.TargetServer;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import java.util.List;

public abstract class BaseEngine
extends Destroyable {
    private static final String CTX_KEY_ENGINE = "key_engine";
    protected final SDKContext sdkContext;
    private List<ServiceCallResultListener> serviceCallResultListeners;

    public BaseEngine(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
    }

    public void init() throws PolarisException {
        this.sdkContext.init();
        this.subInit();
        this.serviceCallResultListeners = ServiceCallResultListener.getServiceCallResultListeners(this.sdkContext);
        this.sdkContext.registerDestroyHook(new Destroyable(){

            protected void doDestroy() {
                if (null != BaseEngine.this.serviceCallResultListeners) {
                    for (ServiceCallResultListener listener : BaseEngine.this.serviceCallResultListeners) {
                        listener.destroy();
                    }
                }
            }
        });
        this.sdkContext.getValueContext().setValue(CTX_KEY_ENGINE, (Object)this);
    }

    public SDKContext getSDKContext() {
        return this.sdkContext;
    }

    protected abstract void subInit() throws PolarisException;

    protected void checkAvailable(String apiName) throws PolarisException {
        if (this.isDestroyed()) {
            throw new PolarisException(ErrorCode.INVALID_STATE, String.format("%s: api instance has been destroyed", apiName));
        }
    }

    protected long getTimeout(RequestBaseEntity entity) {
        return entity.getTimeoutMs() == 0L ? this.sdkContext.getConfig().getGlobal().getAPI().getTimeout() : entity.getTimeoutMs();
    }

    protected void reportInvokeStat(ServiceCallResult req) throws PolarisException {
        for (ServiceCallResultListener listener : this.serviceCallResultListeners) {
            listener.onServiceCallResult((InstanceGauge)req);
        }
    }

    protected void doDestroy() {
        this.sdkContext.doDestroy();
    }

    public static BaseEngine getEngine(ValueContext valueContext) {
        return (BaseEngine)((Object)valueContext.getValue(CTX_KEY_ENGINE));
    }

    public void reportServerCall(ServiceCallResult serviceCallResult, TargetServer targetServer, String method) {
        if (null != targetServer) {
            serviceCallResult.setNamespace(targetServer.getServiceKey().getNamespace());
            serviceCallResult.setService(targetServer.getServiceKey().getService());
            serviceCallResult.setHost(targetServer.getHost());
            serviceCallResult.setPort(targetServer.getPort());
            serviceCallResult.setLabels(targetServer.getLabels());
        }
        serviceCallResult.setMethod(method);
        this.reportInvokeStat(serviceCallResult);
    }
}

