/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.spring.annotation;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.config.spring.annotation.PolarisProcessor;
import com.tencent.cloud.polaris.config.spring.property.PlaceholderHelper;
import com.tencent.cloud.polaris.config.spring.property.SpringValue;
import com.tencent.cloud.polaris.config.spring.property.SpringValueDefinition;
import com.tencent.cloud.polaris.config.spring.property.SpringValueRegistry;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.NonNull;

public class SpringValueProcessor
extends PolarisProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringValueProcessor.class);
    private static final Set<BeanDefinitionRegistry> PROPERTY_VALUES_PROCESSED_BEAN_FACTORIES = Sets.newConcurrentHashSet();
    private static final Map<BeanDefinitionRegistry, Multimap<String, SpringValueDefinition>> BEAN_DEFINITION_REGISTRY_MULTIMAP_CONCURRENT_MAP = Maps.newConcurrentMap();
    private final PolarisConfigProperties polarisConfigProperties;
    private final PlaceholderHelper placeholderHelper;
    private final SpringValueRegistry springValueRegistry;
    private BeanFactory beanFactory;
    private Multimap<String, SpringValueDefinition> beanName2SpringValueDefinitions;

    public SpringValueProcessor(PlaceholderHelper placeholderHelper, SpringValueRegistry springValueRegistry, PolarisConfigProperties polarisConfigProperties) {
        this.placeholderHelper = placeholderHelper;
        this.polarisConfigProperties = polarisConfigProperties;
        this.springValueRegistry = springValueRegistry;
        this.beanName2SpringValueDefinitions = LinkedListMultimap.create();
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.polarisConfigProperties.isAutoRefresh() && beanFactory instanceof BeanDefinitionRegistry) {
            this.beanName2SpringValueDefinitions = this.getBeanName2SpringValueDefinitions((BeanDefinitionRegistry)beanFactory);
        }
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, @NonNull String beanName) throws BeansException {
        if (this.polarisConfigProperties.isAutoRefresh()) {
            super.postProcessBeforeInitialization(bean, beanName);
            this.processBeanPropertyValues(bean, beanName);
        }
        return bean;
    }

    @Override
    protected void processField(Object bean, String beanName, Field field) {
        Value value = field.getAnnotation(Value.class);
        if (value == null) {
            return;
        }
        this.doRegister(bean, beanName, field, value);
    }

    @Override
    protected void processMethod(Object bean, String beanName, Method method) {
        Value value = method.getAnnotation(Value.class);
        if (value == null) {
            return;
        }
        if (method.getAnnotation(Bean.class) != null) {
            return;
        }
        if (method.getParameterTypes().length != 1) {
            LOGGER.error("Ignore @Value setter {}.{}, expecting 1 parameter, actual {} parameters", new Object[]{bean.getClass().getName(), method.getName(), method.getParameterTypes().length});
            return;
        }
        this.doRegister(bean, beanName, method, value);
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        if (this.polarisConfigProperties.isAutoRefresh()) {
            this.processPropertyValues(beanDefinitionRegistry);
        }
    }

    private void doRegister(Object bean, String beanName, Member member, Value value) {
        Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(value.value());
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            SpringValue springValue;
            if (member instanceof Field) {
                Field field = (Field)member;
                springValue = new SpringValue(key, value.value(), bean, beanName, field);
            } else if (member instanceof Method) {
                Method method = (Method)member;
                springValue = new SpringValue(key, value.value(), bean, beanName, method);
            } else {
                LOGGER.error("Polaris @Value annotation currently only support to be used on methods and fields, but is used on {}", member.getClass());
                return;
            }
            this.springValueRegistry.register(this.beanFactory, key, springValue);
            LOGGER.debug("Monitoring {}", (Object)springValue);
        }
    }

    private void processBeanPropertyValues(Object bean, String beanName) {
        Collection propertySpringValues = this.beanName2SpringValueDefinitions.get((Object)beanName);
        if (propertySpringValues.isEmpty()) {
            return;
        }
        for (SpringValueDefinition definition : propertySpringValues) {
            try {
                Method method;
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)definition.getPropertyName());
                if (pd == null || (method = pd.getWriteMethod()) == null) continue;
                SpringValue springValue = new SpringValue(definition.getKey(), definition.getPlaceholder(), bean, beanName, method);
                this.springValueRegistry.register(this.beanFactory, definition.getKey(), springValue);
                LOGGER.debug("Monitoring {}", (Object)springValue);
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to enable auto update feature for {}.{}", bean.getClass(), (Object)definition.getPropertyName());
            }
        }
        this.beanName2SpringValueDefinitions.removeAll((Object)beanName);
    }

    private Multimap<String, SpringValueDefinition> getBeanName2SpringValueDefinitions(BeanDefinitionRegistry registry) {
        LinkedListMultimap springValueDefinitions = BEAN_DEFINITION_REGISTRY_MULTIMAP_CONCURRENT_MAP.remove(registry);
        if (springValueDefinitions == null) {
            springValueDefinitions = LinkedListMultimap.create();
        }
        return springValueDefinitions;
    }

    private void processPropertyValues(BeanDefinitionRegistry beanRegistry) {
        String[] beanNames;
        if (!PROPERTY_VALUES_PROCESSED_BEAN_FACTORIES.add(beanRegistry)) {
            return;
        }
        if (!BEAN_DEFINITION_REGISTRY_MULTIMAP_CONCURRENT_MAP.containsKey(beanRegistry)) {
            BEAN_DEFINITION_REGISTRY_MULTIMAP_CONCURRENT_MAP.put(beanRegistry, (Multimap<String, SpringValueDefinition>)LinkedListMultimap.create());
        }
        Multimap<String, SpringValueDefinition> springValueDefinitions = BEAN_DEFINITION_REGISTRY_MULTIMAP_CONCURRENT_MAP.get(beanRegistry);
        for (String beanName : beanNames = beanRegistry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanRegistry.getBeanDefinition(beanName);
            MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
            List propertyValues = mutablePropertyValues.getPropertyValueList();
            for (PropertyValue propertyValue : propertyValues) {
                String placeholder;
                Set<String> keys;
                Object value = propertyValue.getValue();
                if (!(value instanceof TypedStringValue) || (keys = this.placeholderHelper.extractPlaceholderKeys(placeholder = ((TypedStringValue)value).getValue())).isEmpty()) continue;
                for (String key : keys) {
                    springValueDefinitions.put((Object)beanName, (Object)new SpringValueDefinition(key, placeholder, propertyValue.getName()));
                }
            }
        }
    }
}

