/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.listener;

import com.google.common.collect.Maps;
import com.tencent.cloud.polaris.config.listener.PolarisConfigListenerContext;
import com.tencent.cloud.polaris.config.spring.event.ConfigChangeSpringEvent;
import com.tencent.polaris.configuration.api.core.ConfigPropertyChangeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.lang.NonNull;

public final class PolarisConfigChangeEventListener
implements ApplicationListener<ApplicationEvent>,
ApplicationEventPublisherAware {
    private static final AtomicBoolean started = new AtomicBoolean();
    private ApplicationEventPublisher eventPublisher;

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        ApplicationStartedEvent applicationStartedEvent;
        ConfigurableEnvironment environment;
        Map<String, Object> ret;
        if (event instanceof ApplicationStartedEvent && started.compareAndSet(false, true) && !(ret = this.loadEnvironmentProperties(environment = (applicationStartedEvent = (ApplicationStartedEvent)event).getApplicationContext().getEnvironment())).isEmpty()) {
            PolarisConfigListenerContext.initialize(ret);
        }
        if (event instanceof EnvironmentChangeEvent) {
            EnvironmentChangeEvent environmentChangeEvent = (EnvironmentChangeEvent)event;
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)environmentChangeEvent.getSource();
            ConfigurableEnvironment environment2 = context.getEnvironment();
            Map<String, Object> ret2 = this.loadEnvironmentProperties(environment2);
            Map<String, ConfigPropertyChangeInfo> changes = PolarisConfigListenerContext.merge(ret2);
            ConfigChangeSpringEvent configChangeSpringEvent = new ConfigChangeSpringEvent(new HashMap<String, ConfigPropertyChangeInfo>(changes));
            this.eventPublisher.publishEvent((ApplicationEvent)configChangeSpringEvent);
            PolarisConfigListenerContext.fireConfigChange(changes.keySet(), new HashMap<String, ConfigPropertyChangeInfo>(changes));
            changes.clear();
        }
    }

    private Map<String, Object> loadEnvironmentProperties(ConfigurableEnvironment environment) {
        HashMap ret = Maps.newHashMap();
        MutablePropertySources sources = environment.getPropertySources();
        sources.iterator().forEachRemaining(propertySource -> {
            block3: {
                Object o;
                block2: {
                    o = propertySource.getSource();
                    if (!(o instanceof Map)) break block2;
                    for (Map.Entry entry : ((Map)o).entrySet()) {
                        String key = (String)entry.getKey();
                        String value = environment.getProperty(key);
                        ret.put(key, value);
                    }
                    break block3;
                }
                if (!(o instanceof Collection)) break block3;
                int count = 0;
                Collection collection = (Collection)o;
                for (Object object : collection) {
                    String key = "[" + count++ + "]";
                    ret.put(key, object);
                }
            }
        });
        return ret;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

