/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.configdata;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.cloud.commons.ConfigDataMissingEnvironmentPostProcessor;

public class PolarisImportExceptionFailureAnalyzer
extends AbstractFailureAnalyzer<ConfigDataMissingEnvironmentPostProcessor.ImportException> {
    protected FailureAnalysis analyze(Throwable rootFailure, ConfigDataMissingEnvironmentPostProcessor.ImportException cause) {
        String description = cause.missingPrefix ? "The spring.config.import property is missing a polaris entry" : "No spring.config.import property has been defined";
        String action = "\t1. Add a spring.config.import=polaris property to your configuration.\n\t2. If configuration is not required add spring.config.import=optional:polaris instead.\n\t3. If you still want use bootstrap.yml, you can add <groupId>org.springframework.cloud</groupId> <artifactId>spring-cloud-starter-bootstrap</artifactId> dependency for compatible upgrade.";
        return new FailureAnalysis(description, action, (Throwable)cause);
    }
}

