/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.internal.AdditionalDatabaseMetaData;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.CharacterSet;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OracleDatabaseMetaData
implements AdditionalDatabaseMetaData {
    private static final String DRIVER_NAME = "Oracle JDBC driver";
    private static final String DRIVER_VERSION = "23.7.0.25.01";
    private static final int DRIVER_MAJOR_VERSION = 23;
    private static final int DRIVER_MINOR_VERSION = 7;
    private static final String LOB_MAXSIZE = "4294967295";
    private static final long LOB_MAXLENGTH_32BIT = 0xFFFFFFFFL;
    protected OracleConnection connection;
    private static int DRIVER_API_MAJOR_VERSION = 4;
    private static int DRIVER_API_MINOR_VERSION = 2;
    int procedureResultUnknown = 0;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown = 0;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int procedureColumnResult = 3;
    int procedureNoNulls = 0;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    static final int bestRowTemporary = 0;
    static final int bestRowTransaction = 1;
    static final int bestRowSession = 2;
    static final int bestRowUnknown = 0;
    static final int bestRowNotPseudo = 1;
    static final int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeNoNulls = 0;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredNone = 0;
    int typePredChar = 1;
    int typePredBasic = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;
    short attributeNoNulls = 0;
    short attributeNullable = 1;
    short attributeNullableUnknown = (short)2;
    int sqlStateXOpen = 1;
    int sqlStateSQL99 = 2;
    protected static final String sqlWildcardRegex = "^%|^_|[^/]%|[^/]_";
    protected static Pattern sqlWildcardPattern = null;
    protected static final String sqlEscapeRegex = "/";
    protected static Pattern sqlEscapePattern = null;
    protected Object acProxy;

    public OracleDatabaseMetaData(oracle.jdbc.OracleConnection conn) {
        this.connection = conn.physicalConnectionWithin();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Oracle";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return 23;
    }

    @Override
    public int getDriverMinorVersion() {
        return 7;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,LCASE,LENGTH,LTRIM,OCTET_LENGTH,REPLACE,RTRIM,SOUNDEX,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "USER";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURRENT_DATE,CURRENT_TIMESTAMP,CURDATE,EXTRACT,HOUR,MINUTE,MONTH,SECOND,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return sqlEscapeRegex;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "$#";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 1000;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 2000;
    }

    protected int getIdentifierLength() throws SQLException {
        return this.isCompatible122OrGreater() ? 128 : 30;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1000;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 65535;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getIdentifierLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 2 || level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            String standaloneQuery = "SELECT\n  -- Standalone procedures and functions\n  NULL AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Standalone procedure or function' AS remarks,\n  DECODE(object_type, 'PROCEDURE', 1,\n                      'FUNCTION', 2,\n                      0) AS procedure_type\n,  NULL AS specific_name\nFROM all_objects\nWHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION')\n  AND owner LIKE :1 ESCAPE '/'\n  AND object_name LIKE :2 ESCAPE '/'\n";
            String packagedProceduresSelect = "SELECT\n -- Packaged procedures --\n object_name AS procedure_cat, \n owner AS procedure_schem, \n procedure_name AS procedure_name, \n  NULL,\n  NULL,\n  NULL,\n 'Packaged procedure' AS remarks,\n 1 AS procedure_type\n, NULL AS specific_name\nFROM all_procedures\nWHERE procedure_name IS NOT NULL\n AND ";
            String packagedFunctionsSelectForNotExist = "SELECT NULL\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND   data_level = 0\n  AND ";
            String packagedFunctionsSelect = "SELECT\n  -- Packaged functions\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged function' AS remarks,\n  2 AS procedure_type\n,  NULL AS specific_name\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND   data_level = 0\n  AND ";
            String conditionForNotExistQuery = " AND all_procedures.object_id = all_arguments.object_id  AND all_procedures.subprogram_id = all_arguments.subprogram_id";
            String packagedFunctionsWhereWithCatalog = "package_name LIKE :3 ESCAPE '/'\n  AND owner LIKE :4 ESCAPE '/'\n  AND object_name LIKE :5 ESCAPE '/'\n";
            String packagedProceduresWhereWithCatalog = "object_name LIKE :3 ESCAPE '/'\n  AND owner LIKE :4 ESCAPE '/'\n  AND procedure_name LIKE :5 ESCAPE '/'\n";
            String packagedProceduresWhereNoCatalog = "object_name IS NOT NULL\n  AND owner LIKE :6 ESCAPE '/'\n  AND procedure_name LIKE :7 ESCAPE '/'\n";
            String packagedFunctionsWhereNoCatalog = "package_name IS NOT NULL\n  AND owner LIKE :6 ESCAPE '/'\n  AND object_name LIKE :7 ESCAPE '/'\n";
            String orderBy = "ORDER BY procedure_schem, procedure_name\n";
            PreparedStatement s = null;
            String finalQuery = null;
            String schemaBind = schemaPattern;
            if (schemaPattern == null) {
                schemaBind = "%";
            } else if (schemaPattern.equals("")) {
                schemaBind = this.getUserName().toUpperCase();
            }
            String procedureNameBind = procedureNamePattern;
            if (procedureNamePattern == null) {
                procedureNameBind = "%";
            } else if (procedureNamePattern.equals("")) {
                throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
            }
            if (catalog == null) {
                finalQuery = standaloneQuery + "UNION ALL " + packagedProceduresSelect + packagedProceduresWhereNoCatalog + "AND NOT EXISTS (" + packagedFunctionsSelectForNotExist + packagedFunctionsWhereNoCatalog + conditionForNotExistQuery + ")UNION ALL " + packagedFunctionsSelect + packagedFunctionsWhereNoCatalog + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
                s.setString(3, schemaBind);
                s.setString(4, procedureNameBind);
                s.setString(5, schemaBind);
                s.setString(6, procedureNameBind);
                s.setString(7, schemaBind);
                s.setString(8, procedureNameBind);
            } else if (catalog.equals("")) {
                finalQuery = standaloneQuery;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
            } else {
                finalQuery = packagedProceduresSelect + packagedProceduresWhereWithCatalog + "AND NOT EXISTS (" + packagedFunctionsSelectForNotExist + packagedFunctionsWhereWithCatalog + conditionForNotExistQuery + ")UNION ALL " + packagedFunctionsSelect + packagedFunctionsWhereWithCatalog + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, catalog);
                s.setString(2, schemaBind);
                s.setString(3, procedureNameBind);
                s.setString(4, catalog);
                s.setString(5, schemaBind);
                s.setString(6, procedureNameBind);
                s.setString(7, catalog);
                s.setString(8, schemaBind);
                s.setString(9, procedureNameBind);
            }
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        int paramMaxLength = this.connection.getVersionNumber() < 12000 ? 32 : 128;
        CharacterSet dbCharSet = this.connection.getDbCharSet();
        String invalidLengthParam = null;
        if (catalog != null && dbCharSet.convert(catalog).length > paramMaxLength) {
            invalidLengthParam = "catalog";
        } else if (schemaPattern != null && dbCharSet.convert(schemaPattern).length > paramMaxLength) {
            invalidLengthParam = "schema";
        } else if (procedureNamePattern != null && dbCharSet.convert(procedureNamePattern).length > paramMaxLength) {
            invalidLengthParam = "procedure";
        } else if (columnNamePattern != null && dbCharSet.convert(columnNamePattern).length > paramMaxLength) {
            invalidLengthParam = "column";
        }
        if (invalidLengthParam != null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1715, null, null, invalidLengthParam, paramMaxLength).fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean includeSynonyms = this.connection.getIncludeSynonyms();
            ResultSet rs = null;
            rs = "".equals(catalog) && (schemaPattern == null || !this.hasSqlWildcard(schemaPattern)) && procedureNamePattern != null && !this.hasSqlWildcard(procedureNamePattern) ? this.getUnpackagedProcedureColumnsNoWildcards(schemaPattern != null ? this.stripSqlEscapes(schemaPattern) : null, procedureNamePattern != null ? this.stripSqlEscapes(procedureNamePattern) : null, columnNamePattern, paramMaxLength) : (catalog != null && catalog.length() != 0 && !this.hasSqlWildcard(catalog) && (schemaPattern == null || !this.hasSqlWildcard(schemaPattern)) ? this.getPackagedProcedureColumnsNoWildcards(catalog != null ? this.stripSqlEscapes(catalog) : null, schemaPattern != null ? this.stripSqlEscapes(schemaPattern) : null, procedureNamePattern, columnNamePattern, paramMaxLength) : this.getProcedureColumnsWithWildcards(catalog, schemaPattern, procedureNamePattern, columnNamePattern, includeSynonyms));
            ResultSet resultSet = rs;
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getUnpackagedProcedureColumnsNoWildcards(String schema, String procedureName, String columnNamePattern, int paramMaxLength) throws SQLException {
        ResultSet rs;
        block18: {
            if ("".equals(columnNamePattern)) {
                throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
            }
            String plsql = this.getUnpackagedProcedureColumnsNoWildcardsPlsql(columnNamePattern, paramMaxLength);
            Statement cstmt = null;
            rs = null;
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                cstmt = this.connection.prepareCall(plsql);
                cstmt.unwrap(OracleStatement.class).setLongPrefetch(true);
                cstmt.setString(1, schema);
                cstmt.setString(2, procedureName);
                cstmt.setString(3, columnNamePattern == null ? "%" : columnNamePattern);
                cstmt.registerOutParameter(4, -10);
                cstmt.registerOutParameter(5, 2);
                cstmt.closeOnCompletion();
                cstmt.setPoolable(false);
                cstmt.execute();
                int status = cstmt.getInt(5);
                if (status == 0) {
                    rs = ((OracleCallableStatement)cstmt).getCursor(4);
                    break block18;
                }
                throw (SQLException)DatabaseError.createSqlException(258).fillInStackTrace();
            }
            finally {
                if (rs == null && cstmt != null) {
                    cstmt.close();
                }
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getPackagedProcedureColumnsNoWildcards(String catalog, String schema, String procedureNamePattern, String columnNamePattern, int paramMaxLength) throws SQLException {
        ResultSet rs;
        block18: {
            if ("".equals(columnNamePattern)) {
                throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
            }
            String plsql = this.getPackagedProcedureColumnsNoWildcardsPlsql(columnNamePattern, paramMaxLength);
            Statement cstmt = null;
            rs = null;
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                cstmt = this.connection.prepareCall(plsql);
                cstmt.unwrap(OracleStatement.class).setLongPrefetch(true);
                cstmt.setString(1, catalog);
                cstmt.setString(2, schema);
                cstmt.setString(3, procedureNamePattern);
                cstmt.setString(4, columnNamePattern == null ? "%" : columnNamePattern);
                cstmt.registerOutParameter(5, -10);
                cstmt.registerOutParameter(6, 2);
                cstmt.closeOnCompletion();
                cstmt.setPoolable(false);
                cstmt.execute();
                int status = cstmt.getInt(6);
                if (status == 0) {
                    rs = ((OracleCallableStatement)cstmt).getCursor(5);
                    break block18;
                }
                throw (SQLException)DatabaseError.createSqlException(258).fillInStackTrace();
            }
            finally {
                if (rs == null && cstmt != null) {
                    cstmt.close();
                }
            }
        }
        return rs;
    }

    ResultSet getProcedureColumnsWithWildcards(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern, boolean includeSynonyms) throws SQLException {
        String baseQuery = "SELECT arg.package_name AS procedure_cat,\n       arg.owner AS procedure_schem,\n       arg.object_name AS procedure_name,\n       arg.argument_name AS column_name,\n       DECODE(arg.position, 0, 5,\n                        DECODE(arg.in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n" + this.datatypeQuery(DataTypeSource.ARGS, "arg") + "       NVL2(arg.type_object_type,\n            arg.type_owner || '.' || arg.type_name,\n            DECODE(arg.data_type, 'OBJECT',\n                   arg.type_owner || '.' || arg.type_name,\n                   arg.data_type)) AS type_name,\n       DECODE (arg.data_precision, NULL, arg.data_length,\n                               arg.data_precision) AS precision,\n       arg.data_length AS length,\n       arg.data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       NULL AS remarks,\n       arg.default_value AS column_def,\n       NULL as sql_data_type,\n       NULL AS sql_datetime_sub,\n       DECODE(arg.data_type,\n                         'CHAR', 32767,\n                         'VARCHAR2', 32767,\n                         'LONG', 32767,\n                         'RAW', 32767,\n                         'LONG RAW', 32767,\n                         NULL) AS char_octet_length,\n       (arg.sequence - 1) AS ordinal_position,\n       'YES' AS is_nullable,\n       NULL AS specific_name,\n       arg.sequence,\n       arg.overload,\n       arg.default_value\n FROM all_arguments arg, all_procedures proc\n WHERE arg.owner LIKE :1 ESCAPE '/'\n AND arg.object_name LIKE :2 ESCAPE '/' AND arg.data_level = 0\n";
        short db_version = this.connection.getVersionNumber();
        String objectIDWhere = db_version >= 10200 ? " AND arg.owner = proc.owner\n AND arg.object_id = proc.object_id\n AND arg.subprogram_id = proc.subprogram_id\n" : " AND arg.owner = proc.owner\n AND proc.object_name = arg.package_name\n AND proc.procedure_name = arg.object_name\n";
        String catalogSpecifiedWhere = "  AND arg.package_name LIKE :3 ESCAPE '/'\n";
        String catalogEmptyWhere = "  AND arg.package_name IS NULL\n";
        String columnSpecifiedWhere = "  AND arg.argument_name LIKE :4 ESCAPE '/'\n";
        String columnNotSpecifiedWhere = "  AND (arg.argument_name LIKE :5 ESCAPE '/'\n       OR (arg.argument_name IS NULL\n           AND arg.data_type IS NOT NULL))\n";
        String orderBy = "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
        String finalQuery = null;
        PreparedStatement s = null;
        String columnWhere = null;
        String schemaBind = schemaPattern;
        if (schemaPattern == null) {
            schemaBind = "%";
        } else if (schemaPattern.equals("")) {
            schemaBind = this.getUserName().toUpperCase();
        }
        String procedureNameBind = procedureNamePattern;
        if (procedureNamePattern == null) {
            procedureNameBind = "%";
        } else if (procedureNamePattern.equals("")) {
            throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
        }
        String columnNameBind = columnNamePattern;
        if (columnNamePattern == null || columnNamePattern.equals("%")) {
            columnNameBind = "%";
            columnWhere = columnNotSpecifiedWhere;
        } else {
            if (columnNamePattern.equals("")) {
                throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
            }
            columnWhere = columnSpecifiedWhere;
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            if (catalog == null) {
                finalQuery = baseQuery + objectIDWhere + columnWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
                s.setString(3, columnNameBind);
            } else if (catalog.equals("")) {
                finalQuery = baseQuery + objectIDWhere + catalogEmptyWhere + columnWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
                s.setString(3, columnNameBind);
            } else {
                finalQuery = baseQuery + objectIDWhere + catalogSpecifiedWhere + columnWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
                s.setString(3, catalog);
                s.setString(4, columnNameBind);
            }
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        short db_version = this.connection.getVersionNumber();
        String baseQuery = "SELECT package_name AS function_cat,\n     arg.owner AS function_schem,\n     arg.object_name AS function_name,\n     arg.argument_name AS column_name,\n     DECODE(arg.position,\n            0, 5,\n            DECODE(arg.in_out,\n                   'IN', 1,\n                   'OUT', 3,\n                   'IN/OUT', 2,\n                   0)) AS column_type,\n" + this.datatypeQuery(DataTypeSource.ARGS, "arg") + "     DECODE(arg.data_type,\n            'OBJECT', arg.type_owner || '.' || arg.type_name,             arg.data_type) AS type_name,\n     DECODE(arg.data_precision,\n            NULL, arg.data_length,\n            arg.data_precision) AS precision,\n     arg.data_length AS length,\n     arg.data_scale AS scale,\n     10 AS radix,\n     1 AS nullable,\n     NULL AS remarks,\n     arg.default_value AS column_def,\n     NULL as sql_data_type,\n     NULL AS sql_datetime_sub,\n     DECODE(arg.data_type,\n            'CHAR', 32767,\n            'VARCHAR2', 32767,\n            'LONG', 32767,\n            'RAW', 32767,\n            'LONG RAW', 32767,\n            NULL) AS char_octet_length,\n     (arg.sequence - 1) AS ordinal_position,\n     'YES' AS is_nullable,\n     NULL AS specific_name,\n     arg.sequence,\n     arg.overload,\n     arg.default_value\n FROM all_arguments arg\n" + (db_version >= 10200 ? "" : ", all_procedures proc\n") + " WHERE arg.owner LIKE ? ESCAPE '/'\n  AND arg.object_name LIKE ? ESCAPE '/'\n";
        String objectIDWhere = db_version >= 10200 ? "  AND arg.object_id IN\n  (SELECT object_id FROM all_procedures proc\n   WHERE proc.owner LIKE ? ESCAPE '/'\n    AND\n     ((proc.object_type = 'FUNCTION'\n       AND\n       proc.object_name LIKE ? ESCAPE '/')\n      OR\n      (proc.object_type = 'PACKAGE'\n       AND\n       proc.object_name LIKE ? ESCAPE '/'\n       AND\n       proc.procedure_name IS NOT NULL)\n       AND\n       proc.procedure_name LIKE ? ESCAPE '/'))\n" : "  AND proc.owner = arg.owner\n  AND proc.object_name = arg.object_name\n";
        String catalogSpecifiedWhere = "  AND arg.package_name LIKE ? ESCAPE '/'\n";
        String catalogEmptyWhere = "  AND arg.package_name IS NULL\n";
        String columnSpecifiedWhere = "  AND arg.argument_name LIKE ? ESCAPE '/'\n";
        String columnNotSpecifiedWhere = "  AND (arg.argument_name LIKE ? ESCAPE '/'\n     OR (arg.argument_name IS NULL\n         AND arg.data_type IS NOT NULL))\n";
        String orderBy = " ORDER BY function_schem, function_name, overload, sequence\n";
        String finalQuery = null;
        PreparedStatement s = null;
        String columnWhere = null;
        String schemaBind = schemaPattern;
        if (schemaPattern == null) {
            schemaBind = "%";
        } else if (schemaPattern.equals("")) {
            schemaBind = this.getUserName().toUpperCase();
        }
        String catalogNameBind = catalog;
        if (catalog == null || catalog.equals("")) {
            catalogNameBind = "%";
        }
        String procedureNameBind = functionNamePattern;
        if (functionNamePattern == null) {
            procedureNameBind = "%";
        } else if (functionNamePattern.equals("")) {
            throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
        }
        String columnNameBind = columnNamePattern;
        if (columnNamePattern == null || columnNamePattern.equals("%")) {
            columnNameBind = "%";
            columnWhere = columnNotSpecifiedWhere;
        } else {
            if (columnNamePattern.equals("")) {
                throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
            }
            columnWhere = columnSpecifiedWhere;
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            if (catalog == null) {
                finalQuery = baseQuery + columnWhere + objectIDWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
                s.setString(3, columnNameBind);
                if (db_version >= 10200) {
                    s.setString(4, schemaBind);
                    s.setString(5, procedureNameBind);
                    s.setString(6, catalogNameBind);
                    s.setString(7, procedureNameBind);
                }
            } else if (catalog.equals("")) {
                finalQuery = baseQuery + columnWhere + objectIDWhere + catalogEmptyWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
                s.setString(3, columnNameBind);
                if (db_version >= 10200) {
                    s.setString(4, schemaBind);
                    s.setString(5, procedureNameBind);
                    s.setString(6, catalogNameBind);
                    s.setString(7, procedureNameBind);
                }
            } else {
                finalQuery = baseQuery + columnWhere + objectIDWhere + catalogSpecifiedWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, procedureNameBind);
                s.setString(3, columnNameBind);
                if (db_version >= 10200) {
                    s.setString(4, schemaBind);
                    s.setString(5, procedureNameBind);
                    s.setString(6, catalogNameBind);
                    s.setString(7, procedureNameBind);
                    s.setString(8, catalogNameBind);
                } else {
                    s.setString(4, catalogNameBind);
                }
            }
            s.closeOnCompletion();
            s.unwrap(OracleStatement.class).setLongPrefetch(true);
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            String queryPart1 = "SELECT NULL AS table_cat,\n       o.owner AS table_schem,\n       o.object_name AS table_name,\n       o.object_type AS table_type,\n";
            String remarksSelect = "       c.comments AS remarks\n";
            String noRemarksSelect = "       NULL AS remarks\n";
            String remarksFrom = "  FROM all_objects o, all_tab_comments c\n";
            String noRemarksFrom = "  FROM all_objects o\n";
            String wherePart1 = "  WHERE o.owner LIKE :1 ESCAPE '/'\n    AND o.object_name LIKE :2 ESCAPE '/'\n";
            String whereRemarks = "    AND o.owner = c.owner (+)\n    AND o.object_name = c.table_name (+)\n";
            boolean wantSynonyms = false;
            String whereType = "";
            String whereTypeNoSyn = "";
            if (types != null) {
                whereType = "    AND o.object_type IN ('xxx'";
                whereTypeNoSyn = "    AND o.object_type IN ('xxx'";
                ArrayList<String> validTypes = new ArrayList<String>();
                ResultSet typesRS = this.getTableTypes();
                while (typesRS.next()) {
                    validTypes.add(typesRS.getString(1));
                }
                typesRS.close();
                for (String inType : types) {
                    if (!validTypes.contains(inType)) {
                        if (!this.connection.getJDBCStandardBehavior()) continue;
                        throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                    }
                    if (inType.equals("SYNONYM")) {
                        whereType = whereType + ", '" + inType + "'";
                        wantSynonyms = true;
                        continue;
                    }
                    whereType = whereType + ", '" + inType + "'";
                    whereTypeNoSyn = whereTypeNoSyn + ", '" + inType + "'";
                }
                whereType = whereType + ")\n";
                whereTypeNoSyn = whereTypeNoSyn + ")\n";
            } else {
                wantSynonyms = true;
                whereType = "    AND o.object_type IN ('TABLE', 'SYNONYM', 'VIEW')\n";
                whereTypeNoSyn = "    AND o.object_type IN ('TABLE', 'VIEW')\n";
            }
            String orderBy = "  ORDER BY table_type, table_schem, table_name\n";
            String synonymsUnion = "SELECT NULL AS table_cat,\n       s.owner AS table_schem,\n       s.synonym_name AS table_name,\n       'SYNONYM' AS table_table_type,\n";
            String remarksSynSelect = "       c.comments AS remarks\n";
            String noRemarksSynSelect = "       NULL AS remarks\n";
            String remarksSynFrom = "  FROM all_synonyms s, all_objects o, all_tab_comments c\n";
            String noRemarksSynFrom = "  FROM all_synonyms s, all_objects o\n";
            String synWherePart1 = "  WHERE s.owner LIKE :3 ESCAPE '/'\n    AND s.synonym_name LIKE :4 ESCAPE '/'\n    AND s.table_owner = o.owner\n    AND s.table_name = o.object_name\n    AND o.object_type IN ('TABLE', 'VIEW')\n";
            String finalQuery = "";
            finalQuery = finalQuery + queryPart1;
            finalQuery = this.connection.getRemarksReporting() ? finalQuery + remarksSelect + remarksFrom : finalQuery + noRemarksSelect + noRemarksFrom;
            finalQuery = finalQuery + wherePart1;
            finalQuery = this.connection.getRestrictGetTables() ? finalQuery + whereTypeNoSyn : finalQuery + whereType;
            if (this.connection.getRemarksReporting()) {
                finalQuery = finalQuery + whereRemarks;
            }
            if (wantSynonyms && this.connection.getRestrictGetTables()) {
                finalQuery = finalQuery + "UNION\n" + synonymsUnion;
                finalQuery = this.connection.getRemarksReporting() ? finalQuery + remarksSynSelect + remarksSynFrom : finalQuery + noRemarksSynSelect + noRemarksSynFrom;
                finalQuery = finalQuery + synWherePart1;
                if (this.connection.getRemarksReporting()) {
                    finalQuery = finalQuery + whereRemarks;
                }
            }
            finalQuery = finalQuery + orderBy;
            PreparedStatement s = this.connection.prepareStatement(finalQuery);
            s.setString(1, schemaPattern == null ? "%" : schemaPattern);
            s.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
            if (wantSynonyms && this.connection.getRestrictGetTables()) {
                s.setString(3, schemaPattern == null ? "%" : schemaPattern);
                s.setString(4, tableNamePattern == null ? "%" : tableNamePattern);
            }
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            Statement s = this.connection.createStatement();
            String basic_query = "SELECT username AS table_schem,null as table_catalog  FROM all_users ORDER BY table_schem";
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery(basic_query);
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            Statement s = this.connection.createStatement();
            String query = "select 'nothing' as table_cat from dual where 1 = 2";
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery(query);
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            Statement s = this.connection.createStatement();
            String query = "select 'TABLE' as table_type from dual\nunion select 'VIEW' as table_type from dual\nunion select 'SYNONYM' as table_type from dual\norder by table_type\n";
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery(query);
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            PreparedStatement s = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       column_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_col_privs\nWHERE table_schema LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\n  AND column_name LIKE :3 ESCAPE '/'\nORDER BY column_name, privilege\n");
            s.setString(1, schemaPattern == null ? "%" : schemaPattern);
            s.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
            s.setString(3, columnNamePattern == null ? "%" : columnNamePattern);
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            PreparedStatement s = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_tab_privs\nWHERE table_schema LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\nORDER BY table_schem, table_name, privilege\n");
            s.setString(1, schemaPattern == null ? "%" : schemaPattern);
            s.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            String charDataSize = " DECODE (t.data_type, 'CHAR', t.char_length, 'VARCHAR', t.char_length, 'VARCHAR2', t.char_length, 'NVARCHAR2', t.char_length, 'NCHAR', t.char_length, t.data_length)";
            PreparedStatement s = this.connection.prepareStatement("SELECT 1 AS scope, 'ROWID' AS column_name, -8 AS data_type,\n 'ROWID' AS type_name, 0 AS column_size, 0 AS buffer_length,\n       0 AS decimal_digits, 2 AS pseudo_column\nFROM DUAL\nWHERE :1 = 1\nUNION\nSELECT 2 AS scope,\n t.column_name,\n" + this.datatypeQuery(DataTypeSource.COLS, "t") + " t.data_type AS type_name,\n DECODE (t.data_precision, null, " + charDataSize + ", t.data_precision)\n  AS column_size,\n  0 AS buffer_length,\n  t.data_scale AS decimal_digits,\n       1 AS pseudo_column\nFROM all_tab_columns t, all_ind_columns i\nWHERE :2 = 1\n  AND t.table_name = :3\n  AND t.owner like :4 escape '/'\n  AND t.nullable != :5\n  AND t.owner = i.table_owner\n  AND t.table_name = i.table_name\n  AND t.column_name = i.column_name\n");
            switch (scope) {
                case 0: {
                    s.setInt(1, 0);
                    s.setInt(2, 0);
                    break;
                }
                case 1: {
                    s.setInt(1, 1);
                    s.setInt(2, 1);
                    break;
                }
                case 2: {
                    s.setInt(1, 0);
                    s.setInt(2, 1);
                }
            }
            s.setString(3, table);
            s.setString(4, schema == null ? "%" : schema);
            s.setString(5, nullable ? "X" : "Y");
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            String charDataSize = " DECODE (c.data_type, 'CHAR', c.char_length, 'VARCHAR', c.char_length, 'VARCHAR2', c.char_length, 'NVARCHAR2', c.char_length, 'NCHAR', c.char_length, c.data_length)";
            PreparedStatement s = this.connection.prepareStatement("SELECT 0 AS scope,\n t.column_name,\n" + this.datatypeQuery(DataTypeSource.COLS, "c") + " c.data_type AS type_name,\n DECODE (c.data_precision, null, " + charDataSize + ", c.data_precision)\n   AS column_size,\n       0 as buffer_length,\n   c.data_scale as decimal_digits,\n   0 as pseudo_column\nFROM all_trigger_cols t, all_tab_columns c\nWHERE t.table_name = :1\n  AND c.owner like :2 escape '/'\n AND t.table_owner = c.owner\n  AND t.table_name = c.table_name\n AND t.column_name = c.column_name\n");
            s.setString(1, table);
            s.setString(2, schema == null ? "%" : schema);
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            PreparedStatement s = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       c.owner AS table_schem,\n       c.table_name,\n       c.column_name,\n       c.position AS key_seq,\n       c.constraint_name AS pk_name\nFROM all_cons_columns c, all_constraints k\nWHERE k.constraint_type = 'P'\n  AND k.table_name = :1\n  AND k.owner like :2 escape '/'\n  AND k.constraint_name = c.constraint_name \n  AND k.table_name = c.table_name \n  AND k.owner = c.owner \nORDER BY column_name\n");
            s.setString(1, table);
            s.setString(2, schema == null ? "%" : schema);
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    ResultSet keys_query(String pSchema, String pTable, String fSchema, String fTable, String orderByClause) throws SQLException {
        int i = 1;
        int pTBnd = pTable != null ? i++ : 0;
        int fTBnd = fTable != null ? i++ : 0;
        int pSBnd = pSchema != null && pSchema.length() > 0 ? i++ : 0;
        int fSBnd = fSchema != null && fSchema.length() > 0 ? i++ : 0;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            PreparedStatement s = this.connection.prepareStatement("SELECT NULL AS pktable_cat,\n       p.owner as pktable_schem,\n       p.table_name as pktable_name,\n       pc.column_name as pkcolumn_name,\n       NULL as fktable_cat,\n       f.owner as fktable_schem,\n       f.table_name as fktable_name,\n       fc.column_name as fkcolumn_name,\n       fc.position as key_seq,\n       NULL as update_rule,\n       decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,\n       f.constraint_name as fk_name,\n       p.constraint_name as pk_name,\n       decode(f.deferrable,       'DEFERRABLE',5      ,'NOT DEFERRABLE',7      , 'DEFERRED', 6      ) deferrability \n      FROM all_cons_columns pc, all_constraints p,\n      all_cons_columns fc, all_constraints f\nWHERE 1 = 1\n" + (pTBnd != 0 ? "  AND p.table_name = :1\n" : "") + (fTBnd != 0 ? "  AND f.table_name = :2\n" : "") + (pSBnd != 0 ? "  AND p.owner = :3\n" : "") + (fSBnd != 0 ? "  AND f.owner = :4\n" : "") + "  AND f.constraint_type = 'R'\n  AND p.owner = f.r_owner\n  AND p.constraint_name = f.r_constraint_name\n  AND p.constraint_type = 'P'\n  AND pc.owner = p.owner\n  AND pc.constraint_name = p.constraint_name\n  AND pc.table_name = p.table_name\n  AND fc.owner = f.owner\n  AND fc.constraint_name = f.constraint_name\n  AND fc.table_name = f.table_name\n  AND fc.position = pc.position\n" + orderByClause);
            if (pTBnd != 0) {
                s.setString(pTBnd, pTable);
            }
            if (fTBnd != 0) {
                s.setString(fTBnd, fTable);
            }
            if (pSBnd != 0) {
                s.setString(pSBnd, pSchema);
            }
            if (fSBnd != 0) {
                s.setString(fSBnd, fSchema);
            }
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ResultSet resultSet = this.keys_query(null, null, schema, table, "ORDER BY pktable_schem, pktable_name, key_seq");
            return resultSet;
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ResultSet resultSet = this.keys_query(schema, table, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
            return resultSet;
        }
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ResultSet resultSet = this.keys_query(primarySchema, primaryTable, foreignSchema, foreignTable, "ORDER BY fktable_schem, fktable_name, key_seq");
            return resultSet;
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    private static final String quoteDatabaseObjectName(String n) {
        if (n == null || n.length() == 0) {
            return "''";
        }
        assert (OracleSql.isValidObjectName(n)) : "n is invalid \"" + n + "\"";
        return (n.charAt(0) == '\"' ? "Q'" : "'") + n + "'";
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            Statement s = this.connection.createStatement();
            if (schema != null && schema.length() != 0 && !OracleSql.isValidObjectName(schema) || table != null && table.length() != 0 && !OracleSql.isValidObjectName(table)) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            if (!approximate) {
                boolean inTransaction = false;
                try {
                    inTransaction = this.connection.inLocalTransaction();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!inTransaction) {
                    CallableStatement cs = this.connection.prepareCall("begin DBMS_STATS.GATHER_TABLE_STATS(?,?); end;");
                    cs.setString(1, schema == null ? "" : schema);
                    cs.setString(2, table);
                    cs.executeUpdate();
                    cs.close();
                }
            }
            String table_query = "select null as table_cat,\n       owner as table_schem,\n       table_name,\n       0 as NON_UNIQUE,\n       null as index_qualifier,\n       null as index_name, 0 as type,\n       0 as ordinal_position, null as column_name,\n       null as asc_or_desc,\n       num_rows as cardinality,\n       blocks as pages,\n       null as filter_condition\nfrom all_tables\nwhere table_name = " + OracleDatabaseMetaData.quoteDatabaseObjectName(table) + "\n";
            String table_schema_select = "";
            if (schema != null && schema.length() > 0) {
                table_schema_select = "  and owner = " + OracleDatabaseMetaData.quoteDatabaseObjectName(schema) + "\n";
            }
            String index_query = "select null as table_cat,\n       i.owner as table_schem,\n       i.table_name,\n       decode (i.uniqueness, 'UNIQUE', 0, 1),\n       null as index_qualifier,\n       i.index_name,\n       1 as type,\n       c.column_position as ordinal_position,\n       c.column_name,\n       null as asc_or_desc,\n       i.distinct_keys as cardinality,\n       i.leaf_blocks as pages,\n       null as filter_condition\nfrom all_indexes i, all_ind_columns c\nwhere i.table_name = " + OracleDatabaseMetaData.quoteDatabaseObjectName(table) + "\n";
            String index_schema_select = "";
            if (schema != null && schema.length() > 0) {
                index_schema_select = "  and i.owner = " + OracleDatabaseMetaData.quoteDatabaseObjectName(schema) + "\n";
            }
            String index_unique_select = "";
            if (unique) {
                index_unique_select = "  and i.uniqueness = 'UNIQUE'\n";
            }
            String index_join_select = "  and i.index_name = c.index_name\n  and i.table_owner = c.table_owner\n  and i.table_name = c.table_name\n  and i.owner = c.index_owner\n";
            String index_order_by = "order by non_unique, type, index_name, ordinal_position\n";
            String query = table_query + table_schema_select + "union\n" + index_query + index_schema_select + index_unique_select + index_join_select + index_order_by;
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery(query);
            return oracleResultSet;
        }
    }

    SQLException fail() {
        SQLException ex = new SQLException("Not implemented yet");
        return ex;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return type != 1003;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return type != 1003;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return type == 1005;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        boolean _queryADT = false;
        if (typeNamePattern == null || typeNamePattern.length() == 0) {
            _queryADT = false;
        } else if (types == null) {
            _queryADT = true;
        } else {
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != 2002) continue;
                _queryADT = true;
                break;
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT NULL AS TYPE_CAT, owner AS TYPE_SCHEM, type_name, NULL AS CLASS_NAME, 'STRUCT' AS DATA_TYPE, NULL AS REMARKS FROM all_types ");
        if (_queryADT) {
            sql.append("WHERE typecode = 'OBJECT' AND owner LIKE :1 ESCAPE '/' AND type_name LIKE :2 ESCAPE '/'");
        } else {
            sql.append("WHERE 1 = 2");
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            PreparedStatement s = this.connection.prepareStatement(sql.substring(0, sql.length()));
            if (_queryADT) {
                String[] _schema = new String[1];
                String[] _type = new String[1];
                if (SQLName.parse(typeNamePattern, _schema, _type)) {
                    s.setString(1, _schema[0]);
                    s.setString(2, _type[0]);
                } else {
                    if (schemaPattern != null) {
                        s.setString(1, schemaPattern);
                    } else {
                        s.setNull(1, 12);
                    }
                    s.setString(2, typeNamePattern);
                }
            }
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection.getWrapper();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getMajorVersionNumber();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getMinorVersionNumber();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return DRIVER_API_MAJOR_VERSION;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return DRIVER_API_MINOR_VERSION;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    public static String getDriverNameInfo() throws SQLException {
        return DRIVER_NAME;
    }

    public static String getDriverVersionInfo() throws SQLException {
        return DRIVER_VERSION;
    }

    public static int getDriverMajorVersionInfo() {
        return 23;
    }

    public static int getDriverMinorVersionInfo() {
        return 7;
    }

    public static String getLobPrecision() throws SQLException {
        return "-1";
    }

    @Override
    public long getLobMaxLength() throws SQLException {
        return this.connection.getVersionNumber() >= 10000 ? Long.MAX_VALUE : 0xFFFFFFFFL;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            if (schemaPattern == null) {
                ResultSet resultSet = this.getSchemas();
                return resultSet;
            }
            String basicQuery = "SELECT username AS table_schem, null as table_catalog FROM all_users WHERE username LIKE ? ORDER BY table_schem";
            PreparedStatement ps = this.connection.prepareStatement(basicQuery);
            ps.setString(1, schemaPattern);
            ps.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)ps.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Statement stmt = this.connection.createStatement();
            stmt.closeOnCompletion();
            ResultSet resultSet = stmt.executeQuery("select NULL NAME, -1 MAX_LEN, NULL DEFAULT_VALUE, NULL DESCRIPTION  from dual where 0 = 1");
            return resultSet;
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String standaloneQuery = "SELECT\n  -- Standalone functions\n  NULL AS function_cat,\n  owner AS function_schem,\n  object_name AS function_name,\n  'Standalone function' AS remarks,\n  0 AS function_type,\n  NULL AS specific_name\nFROM all_objects\nWHERE object_type = 'FUNCTION'\n  AND owner LIKE :1 ESCAPE '/'\n  AND object_name LIKE :2 ESCAPE '/'\n";
        String packagedFunctionsSelect = "SELECT\n  -- Packaged functions\n  package_name AS function_cat,\n  owner AS function_schem,\n  object_name AS function_name,\n  'Packaged function' AS remarks,\n  decode (data_type, 'TABLE', 2, 'PL/SQL TABLE', 2, 1) AS function_type,\n  NULL AS specific_name\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND data_level = 0\n";
        String catalogSpecifiedWhere = "  AND package_name LIKE :3 ESCAPE '/'\n  AND owner LIKE :4 ESCAPE '/'\n  AND object_name LIKE :5 ESCAPE '/'\n";
        String catalogNotSpecifiedWhere = "  AND package_name IS NOT NULL\n  AND owner LIKE :6 ESCAPE '/'\n  AND object_name LIKE :7 ESCAPE '/'\n";
        String orderBy = "ORDER BY function_schem, function_name\n";
        PreparedStatement s = null;
        String finalQuery = null;
        String schemaBind = schemaPattern;
        if (schemaPattern == null) {
            schemaBind = "%";
        } else if (schemaPattern.equals("")) {
            schemaBind = this.getUserName().toUpperCase();
        }
        String functionNameBind = functionNamePattern;
        if (functionNamePattern == null) {
            functionNameBind = "%";
        } else if (functionNamePattern.equals("")) {
            throw (SQLException)DatabaseError.createSqlException(74).fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            if (catalog == null) {
                finalQuery = standaloneQuery + "UNION ALL " + packagedFunctionsSelect + catalogNotSpecifiedWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, functionNameBind);
                s.setString(3, schemaBind);
                s.setString(4, functionNameBind);
            } else if (catalog.equals("")) {
                finalQuery = standaloneQuery;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, schemaBind);
                s.setString(2, functionNameBind);
            } else {
                finalQuery = packagedFunctionsSelect + catalogSpecifiedWhere + orderBy;
                s = this.connection.prepareStatement(finalQuery);
                s.setString(1, catalog);
                s.setString(2, schemaBind);
                s.setString(3, functionNameBind);
            }
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery();
            return oracleResultSet;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    protected boolean hasSqlWildcard(String s) {
        if (sqlWildcardPattern == null) {
            sqlWildcardPattern = Pattern.compile(sqlWildcardRegex);
        }
        Matcher m = sqlWildcardPattern.matcher(s);
        return m.find();
    }

    protected String stripSqlEscapes(String s) {
        if (sqlEscapePattern == null) {
            sqlEscapePattern = Pattern.compile(sqlEscapeRegex);
        }
        Matcher m = sqlEscapePattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    String getUnpackagedProcedureColumnsNoWildcardsPlsql(String colNamePattern, int paramMaxLength) throws SQLException {
        String searchPlsql = "declare\n  in_owner varchar2(" + paramMaxLength + ") := null;\n  in_name varchar2(" + paramMaxLength + ") := null;\n  my_user_name varchar2(" + paramMaxLength + ") := null;\n  cnt number := 0;\n  temp_owner varchar2(" + paramMaxLength + ") := null;\n  temp_name  varchar2(" + paramMaxLength + "):= null;\n  out_owner varchar2(" + paramMaxLength + ") := null;\n  out_name  varchar2(" + paramMaxLength + "):= null;\n  loc varchar2(" + paramMaxLength + ") := null;\n  status number := 0;\n  TYPE recursion_check_type is table of number index by varchar2(" + (paramMaxLength * 2 + 1) + ");\n  recursion_check recursion_check_type;\n  dotted_name varchar2(" + (paramMaxLength * 2 + 1) + ");\n  recursion_cnt number := 0;\n  xxx SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if( my_user_name = in_owner ) then\n    select count(*) into cnt from user_procedures where object_name = in_name;\n    if( cnt = 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'USER_PROCEDURES';\n    end if;\n  else\n    select count(*) into cnt from all_arguments where owner = in_owner and object_name = in_name;\n    if( cnt >= 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'ALL_ARGUMENTS';\n    end if;\n  end if;\n  if loc is null then\n    temp_owner := in_owner;\n    temp_name := in_name;\n    loop\n      begin\n        dotted_name := temp_owner || '.' ||temp_name;\n        begin\n          recursion_cnt := recursion_check(dotted_name );\n          status := -1;\n          exit;\n        exception\n        when NO_DATA_FOUND then\n          recursion_check( dotted_name ) := 1;\n        end;\n        select table_owner, table_name into out_owner, out_name from all_synonyms \n          where  owner = temp_owner and synonym_name = temp_name;\n        cnt := cnt + 1;\n        temp_owner  := out_owner;\n        temp_name := out_name;\n        exception\n        when NO_DATA_FOUND then\n          exit;\n        end;\n      end loop;\n      if( not(out_owner is null) ) then\n        loc := 'ALL_SYNONYMS';\n    end if;\n  end if;\n";
        String queryPart1 = "if( status = 0 ) then \n open xxx for \n";
        String baseQuery = "SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n" + this.datatypeQuery(DataTypeSource.ARGS) + "       DECODE(data_type, 'OBJECT', type_owner || '.' || type_name,               data_type) AS type_name,\n       DECODE (data_precision, NULL, data_length,\n                               data_precision) AS precision,\n       data_length AS length,\n       data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       NULL AS remarks,\n       default_value AS column_def,\n       NULL as sql_data_type,\n       NULL AS sql_datetime_sub,\n       DECODE(data_type,\n                         'CHAR', 32767,\n                         'VARCHAR2', 32767,\n                         'LONG', 32767,\n                         'RAW', 32767,\n                         'LONG RAW', 32767,\n                         NULL) AS char_octet_length,\n       (sequence - 1) AS ordinal_position,\n       'YES' AS is_nullable,\n       NULL AS specific_name,\n       sequence,\n       overload,\n       default_value\n";
        String fromClause = "FROM all_arguments a";
        String whereClause = "WHERE a.owner = out_owner \n AND a.object_name = out_name\n AND data_level = 0\n AND package_name is null\n";
        String colWhere = colNamePattern == null || colNamePattern.equals("%") ? " AND (argument_name LIKE ? ESCAPE '/'\n      OR (argument_name IS NULL\n          AND data_type IS NOT NULL))\n" : " AND a.argument_name LIKE ? ESCAPE '/'\n";
        String orderBy = "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
        String queryPlsql = queryPart1;
        queryPlsql = queryPlsql + baseQuery;
        queryPlsql = queryPlsql + fromClause;
        queryPlsql = queryPlsql + "\n" + whereClause;
        queryPlsql = queryPlsql + "\n" + colWhere;
        queryPlsql = queryPlsql + "\n" + orderBy;
        String plsqlPost = "; \n end if;\n  ? := xxx; ? := status;\n end;";
        String finalProc = searchPlsql + queryPlsql + plsqlPost;
        return finalProc;
    }

    String getPackagedProcedureColumnsNoWildcardsPlsql(String colNamePattern, int paramMaxLength) throws SQLException {
        String searchPlsql = "declare\n  in_package_name varchar2(" + paramMaxLength + ") := null;\n  in_owner varchar2(" + paramMaxLength + ") := null;\n  in_name varchar2(" + paramMaxLength + ") := null;\n  my_user_name varchar2(" + paramMaxLength + ") := null;\n  cnt number := 0;\n  temp_package_name varchar2(" + paramMaxLength + ") := null;\n  temp_owner varchar2(" + paramMaxLength + ") := null;\n  out_package_name varchar2(" + paramMaxLength + ") := null;\n  out_owner varchar2(" + paramMaxLength + ") := null;\n  loc varchar2(" + paramMaxLength + ") := null;\n  status number := 0;\n  TYPE recursion_check_type is table of number index by varchar2(" + (paramMaxLength * 2 + 1) + ");\n  recursion_check recursion_check_type;\n  dotted_name varchar2(" + (paramMaxLength * 2 + 1) + ");\n  recursion_cnt number := 0;\n  xxx SYS_REFCURSOR;\nbegin\n  in_package_name := ?;\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if( in_owner is null ) then\n    select count(*) into cnt from all_arguments where package_name = in_package_name;\n    if( cnt >= 1 ) then\n      out_owner := '%';\n      out_package_name := in_package_name;\n      loc := 'ALL_ARGUMENTS';\n    end if;\n  elsif( my_user_name = in_owner ) then\n    select count(*) into cnt from user_arguments where package_name = in_package_name;\n    if( cnt >= 1 ) then\n      out_owner := in_owner;\n      out_package_name := in_package_name;\n      loc := 'USER_ARGUMENTS';\n    end if;\n  else\n    select count(*) into cnt from all_arguments where owner = in_owner and package_name = in_package_name;\n    if( cnt >= 1 ) then\n      out_owner := in_owner;\n      out_package_name := in_package_name;\n      loc := 'ALL_ARGUMENTS';\n    end if;\n  end if;\n  if loc is null then\n  temp_owner := in_owner;\n  temp_package_name := in_package_name;\n  loop\n    begin\n      dotted_name := temp_owner || '.' ||temp_package_name;\n      begin\n        recursion_cnt := recursion_check(dotted_name );\n        status := -1;\n        exit;\n      exception\n      when NO_DATA_FOUND then\n        recursion_check( dotted_name ) := 1;\n      end;\n      select table_owner, table_name into out_owner, out_package_name from all_synonyms \n        where  owner = temp_owner and synonym_name = temp_package_name;\n      cnt := cnt + 1;\n      temp_owner  := out_owner;\n      temp_package_name := out_package_name;\n      exception\n      when NO_DATA_FOUND then\n        exit;\n      end;\n    end loop;\n    if( not(out_owner is null) ) then\n      loc := 'ALL_SYNONYMS';\n    end if;\n  end if;\n";
        short db_version = this.connection.getVersionNumber();
        String queryPart1 = "if( status = 0 ) then \n open xxx for \n";
        String baseQuery = "SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n" + this.datatypeQuery(DataTypeSource.ARGS) + "       DECODE(data_type, 'OBJECT', type_owner || '.' || type_name,               data_type) AS type_name,\n       DECODE (data_precision, NULL, data_length,\n                               data_precision) AS precision,\n       data_length AS length,\n       data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       NULL AS remarks,\n       default_value AS column_def,\n       NULL as sql_data_type,\n       NULL AS sql_datetime_sub,\n       DECODE(data_type,\n                         'CHAR', 32767,\n                         'VARCHAR2', 32767,\n                         'LONG', 32767,\n                         'RAW', 32767,\n                         'LONG RAW', 32767,\n                         NULL) AS char_octet_length,\n       (sequence - 1) AS ordinal_position,\n       'YES' AS is_nullable,\n       NULL AS specific_name,\n       sequence,\n       overload,\n       default_value\n";
        String fromClause = "FROM all_arguments a";
        String whereClause = "WHERE a.owner LIKE out_owner \n  AND a.object_name LIKE in_name ESCAPE '/' \n AND data_level = 0\n AND package_name = out_package_name\n";
        String colWhere = colNamePattern == null || colNamePattern.equals("%") ? " AND (argument_name LIKE ? ESCAPE '/'\n      OR (argument_name IS NULL\n          AND data_type IS NOT NULL))\n" : " AND a.argument_name LIKE ? ESCAPE '/'\n";
        String orderBy = "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
        String queryPlsql = queryPart1;
        queryPlsql = queryPlsql + baseQuery;
        queryPlsql = queryPlsql + fromClause;
        queryPlsql = queryPlsql + "\n" + whereClause;
        queryPlsql = queryPlsql + "\n" + colWhere;
        queryPlsql = queryPlsql + "\n" + orderBy;
        String plsqlPost = "; \n end if;\n  ? := xxx; ? := status;\n end;";
        String finalProc = searchPlsql + queryPlsql + plsqlPost;
        return finalProc;
    }

    @Override
    public OracleTypeMetaData getOracleTypeMetaData(String sqlTypeName) throws SQLException {
        return TypeDescriptor.getTypeDescriptor(sqlTypeName, this.connection);
    }

    protected String datatypeQuery(DataTypeSource src) {
        return this.datatypeQuery(src, null);
    }

    protected String datatypeQuery(DataTypeSource src, String table) {
        String alias = "";
        String additionalPredicate = "";
        if (table != null && table != "") {
            alias = table + ".";
        }
        if (src == DataTypeSource.COLS) {
            additionalPredicate = "       AND ((a.owner IS NULL AND \n" + alias + "data_type_owner IS NULL)\n         OR (a.owner = " + alias + "data_type_owner))\n";
        }
        String returnQuery = "  DECODE(substr(" + alias + "data_type, 1, 9), \n    'TIMESTAMP', \n      DECODE(substr(" + alias + "data_type, 10, 1), \n        '(', \n          DECODE(substr(" + alias + "data_type, 19, 5), \n            'LOCAL', -102, 'TIME ', -101, 93), \n        DECODE(substr(" + alias + "data_type, 16, 5), \n          'LOCAL', -102, 'TIME ', -101, 93)), \n    'INTERVAL ', \n      DECODE(substr(" + alias + "data_type, 10, 3), \n       'DAY', -104, 'YEA', -103), \n    DECODE(" + alias + "data_type, \n      'BINARY_DOUBLE', 101, \n      'BINARY_FLOAT', 100, \n      'BFILE', -13, \n      'BLOB', 2004, \n      'BOOLEAN', 16, \n      'CHAR', 1, \n      'CLOB', 2005, \n      'COLLECTION', 2003, \n      'DATE', " + (this.connection.getMapDateToTimestamp() ? "93" : "91") + ", \n      'FLOAT', 6, \n      'JSON', 2016, \n      'LONG', -1, \n      'LONG RAW', -4, \n      'NCHAR', -15, \n      'NCLOB', 2011, \n      'NUMBER', 2, \n      'NVARCHAR', -9, \n      'NVARCHAR2', -9, \n      'OBJECT', 2002, \n      'OPAQUE/XMLTYPE', 2009, \n      'RAW', -3, \n      'REF', 2006, \n      'ROWID', -8, \n      'SQLXML', 2009, \n      'UROWID', -8, \n      'VARCHAR2', 12, \n      'VARRAY', 2003, \n      'VECTOR', -105, \n      'XMLTYPE', 2009, \n      DECODE((SELECT a.typecode \n        FROM ALL_TYPES a \n        WHERE a.type_name = " + alias + "data_type\n" + additionalPredicate + "        ), \n        'OBJECT', 2002, \n        'COLLECTION', 2003, 1111))) \n AS data_type,\n";
        return returnQuery;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String schemaBind;
        String string = schemaBind = schemaPattern == null ? "%" : schemaPattern;
        if (tableNamePattern != null) {
            if (tableNamePattern.startsWith("\"") && tableNamePattern.endsWith("\"")) {
                tableNamePattern = tableNamePattern.substring(1, tableNamePattern.length() - 1);
            }
            if (tableNamePattern.indexOf(39) != -1) {
                tableNamePattern = tableNamePattern.replaceAll("'", "''");
            }
        }
        String subqueries = this.pseudoColumnRow(schemaBind, tableNamePattern, "ORA_ROWSCN", 2, 10) + "union\n" + this.pseudoColumnRow(schemaBind, tableNamePattern, "ROWID", -8, 18) + "union\n" + this.pseudoColumnRow(schemaBind, tableNamePattern, "ROWNUM", 2, 10) + "union\n" + this.pseudoColumnRealRows(schemaBind, tableNamePattern);
        String columnBind = columnNamePattern == null ? "%" : columnNamePattern;
        String sql = "select *\nfrom (" + subqueries + ")\nwhere column_name like '" + columnBind + "'\norder by column_name";
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ps.closeOnCompletion();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    private String pseudoColumnRealRows(String schemaPattern, String tableNamePattern) throws SQLException {
        String charDataSize = " DECODE (data_type, 'CHAR', char_length, 'VARCHAR', char_length, 'VARCHAR2', char_length, 'NVARCHAR2', char_length, 'NCHAR', char_length, data_length)";
        String sql = "select null as TABLE_CAT,\n  owner as TABLE_SCHEM,\n  table_name as TABLE_NAME,\n  column_name  as COLUMN_NAME,\n" + this.datatypeQuery(DataTypeSource.COLS) + " DECODE (data_precision, null, " + charDataSize + ", data_precision)\n  as COLUMN_SIZE,\n  data_scale as DECIMAL_DIGITS,\n  10 as NUM_PREC_RADIX,\n  'NO_USAGE_RESTRICTONS' as COLUMN_USAGE,\n  null as REMARKS,\n  null as CHAR_OCTET_LENGTH,\n  decode(nullable, 'Y', 'YES', 'NO') as IS_NULLABLE\nfrom all_tab_cols\nwhere\n  hidden_column = 'YES' and\n  owner like '" + schemaPattern + "' and\n  table_name like '" + tableNamePattern + "' ESCAPE '/'\n";
        return sql;
    }

    private String pseudoColumnRow(String schemaPattern, String tableNamePattern, String columnName, int dataType, int columnSize) throws SQLException {
        String sql = "  select null as TABLE_CAT,\n  owner as TABLE_SCHEM,\n  table_name as TABLE_NAME,\n  '" + columnName + "' as COLUMN_NAME,\n  " + dataType + " as DATA_TYPE,\n  " + columnSize + " as COLUMN_SIZE,\n  " + (columnName.equals("ROWID") ? "null" : "38") + " as DECIMAL_DIGITS,\n  10 as NUM_PREC_RADIX,\n  'NO_USAGE_RESTRICTONS' as COLUMN_USAGE,\n  null as REMARKS,\n  null as CHAR_OCTET_LENGTH,\n  'NO' as IS_NULLABLE\nfrom all_tables\nwhere\n  owner like '" + schemaPattern + "' and\n  table_name like '" + tableNamePattern + "' ESCAPE '/'\n";
        return sql;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public String getAuditBanner() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public String getAccessBanner() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean isServerBigSCN() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    public boolean isCompatible122OrGreater() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDualityView(String viewName) throws SQLException {
        String sql = "select duality_view from user_views where view_name=?";
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Throwable throwable;
            ResultSet rs;
            block30: {
                PreparedStatement ps = this.connection.prepareStatement(sql);
                ps.setString(1, viewName);
                ps.closeOnCompletion();
                try {
                    boolean bl;
                    block31: {
                        rs = ps.executeQuery();
                        throwable = null;
                        try {
                            if (!rs.next() || !rs.getString("DUALITY_VIEW").equalsIgnoreCase("YES")) break block30;
                            bl = true;
                            if (rs == null) return bl;
                            if (throwable == null) break block31;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (rs == null) throw throwable5;
                                if (throwable != null) {
                                    try {
                                        rs.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                                rs.close();
                                throw throwable5;
                            }
                        }
                        try {
                            rs.close();
                            return bl;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return bl;
                        }
                    }
                    rs.close();
                    return bl;
                }
                catch (SQLException e) {
                    ps.close();
                    return false;
                }
            }
            if (rs == null) return false;
            if (throwable == null) {
                rs.close();
                return false;
            }
            try {
                rs.close();
                return false;
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
                return false;
            }
        }
    }

    @Override
    public ResultSet getJsonSchema(String viewName) throws SQLException {
        String sql = "select dbms_json_schema.describe(?)";
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ps.setString(1, viewName);
            ps.closeOnCompletion();
            try {
                ResultSet resultSet = ps.executeQuery();
                return resultSet;
            }
            catch (SQLException e) {
                try {
                    ps.close();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    protected static enum DataTypeSource {
        COLS,
        ARGS;

    }
}

