/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class ClientRegistrationRequest
extends ProtectedResourceRequest {
    private final ClientMetadata metadata;
    private final SignedJWT softwareStatement;

    public ClientRegistrationRequest(URI uri, ClientMetadata metadata, BearerAccessToken accessToken) {
        this(uri, metadata, null, accessToken);
    }

    public ClientRegistrationRequest(URI uri, ClientMetadata metadata, SignedJWT softwareStatement, BearerAccessToken accessToken) {
        super(uri, accessToken);
        if (metadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = metadata;
        if (softwareStatement != null) {
            ReadOnlyJWTClaimsSet claimsSet;
            if (softwareStatement.getState() == JWSObject.State.UNSIGNED) {
                throw new IllegalArgumentException("The software statement JWT must be signed");
            }
            try {
                claimsSet = softwareStatement.getJWTClaimsSet();
            }
            catch (java.text.ParseException e) {
                throw new IllegalArgumentException("The software statement is not a valid signed JWT: " + e.getMessage());
            }
            if (claimsSet.getIssuer() == null) {
                throw new IllegalArgumentException("The software statement JWT must contain an 'iss' claim");
            }
        }
        this.softwareStatement = softwareStatement;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public SignedJWT getSoftwareStatement() {
        return this.softwareStatement;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        URL endpointURL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            endpointURL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, endpointURL);
        if (this.getAccessToken() != null) {
            httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        }
        httpRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        JSONObject content = this.metadata.toJSONObject();
        if (this.softwareStatement != null) {
            content.put((Object)"software_statement", (Object)this.softwareStatement.serialize());
        }
        httpRequest.setQuery(content.toString());
        return httpRequest;
    }

    public static ClientRegistrationRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jsonObject = httpRequest.getQueryAsJSONObject();
        SignedJWT stmt = null;
        if (jsonObject.containsKey((Object)"software_statement")) {
            try {
                stmt = SignedJWT.parse((String)JSONObjectUtils.getString(jsonObject, "software_statement"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid software statement JWT: " + e.getMessage());
            }
            jsonObject.remove((Object)"software_statement");
        }
        ClientMetadata metadata = ClientMetadata.parse(jsonObject);
        BearerAccessToken accessToken = null;
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isNotBlank((CharSequence)authzHeaderValue)) {
            accessToken = BearerAccessToken.parse(authzHeaderValue);
        }
        try {
            URI endpointURI = httpRequest.getURL().toURI();
            return new ClientRegistrationRequest(endpointURI, metadata, stmt, accessToken);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

