/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import com.netflix.client.http.HttpResponse;
import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.zuul.message.HeaderName;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestMessage;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

public class ProxyUtils {
    private static final CachedDynamicBooleanProperty OVERWRITE_XF_HEADERS = new CachedDynamicBooleanProperty("zuul.headers.xforwarded.overwrite", false);
    private static final Set<HeaderName> RESP_HEADERS_TO_STRIP = new HashSet<HeaderName>();
    private static final Set<HeaderName> REQ_HEADERS_TO_STRIP;

    public static boolean isValidRequestHeader(HeaderName headerName) {
        return !REQ_HEADERS_TO_STRIP.contains(headerName);
    }

    public static boolean isValidResponseHeader(HeaderName headerName) {
        return !RESP_HEADERS_TO_STRIP.contains(headerName);
    }

    public static void addXForwardedHeaders(HttpRequestMessage request) {
        Headers headers = request.getHeaders();
        ProxyUtils.addXForwardedHeader(headers, HttpHeaderNames.X_FORWARDED_HOST, request.getOriginalHost());
        ProxyUtils.addXForwardedHeader(headers, HttpHeaderNames.X_FORWARDED_PORT, Integer.toString(request.getPort()));
        ProxyUtils.addXForwardedHeader(headers, HttpHeaderNames.X_FORWARDED_PROTO, request.getScheme());
        ProxyUtils.addXForwardedHeader(headers, HttpHeaderNames.X_FORWARDED_FOR, request.getClientIp());
    }

    public static void addXForwardedHeader(Headers headers, HeaderName name, String latestValue) {
        if (OVERWRITE_XF_HEADERS.get()) {
            headers.set(name, latestValue);
        } else {
            String existingValue = headers.getFirst(name);
            if (existingValue == null && latestValue != null) {
                headers.set(name, latestValue);
            }
        }
    }

    static {
        RESP_HEADERS_TO_STRIP.add(HttpHeaderNames.CONNECTION);
        RESP_HEADERS_TO_STRIP.add(HttpHeaderNames.TRANSFER_ENCODING);
        RESP_HEADERS_TO_STRIP.add(HttpHeaderNames.KEEP_ALIVE);
        REQ_HEADERS_TO_STRIP = new HashSet<HeaderName>();
        REQ_HEADERS_TO_STRIP.add(HttpHeaderNames.CONTENT_LENGTH);
        REQ_HEADERS_TO_STRIP.add(HttpHeaderNames.CONNECTION);
        REQ_HEADERS_TO_STRIP.add(HttpHeaderNames.TRANSFER_ENCODING);
        REQ_HEADERS_TO_STRIP.add(HttpHeaderNames.KEEP_ALIVE);
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class TestUnit {
        @Mock
        HttpResponse proxyResp;
        @Mock
        HttpRequestMessage request;

        @Test
        public void testIsValidResponseHeader() {
            Assert.assertTrue((boolean)ProxyUtils.isValidResponseHeader(HttpHeaderNames.get("test")));
            Assert.assertFalse((boolean)ProxyUtils.isValidResponseHeader(HttpHeaderNames.get("Keep-Alive")));
            Assert.assertFalse((boolean)ProxyUtils.isValidResponseHeader(HttpHeaderNames.get("keep-alive")));
        }
    }
}

