/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZuulEvent {
    private static final Logger LOG = LoggerFactory.getLogger(ZuulEvent.class);
    private static final String TYPE_KEY = "type";
    private final JSONObject json;

    public ZuulEvent() {
        this(new JSONObject());
    }

    public ZuulEvent(JSONObject json) {
        this.json = json;
    }

    @Deprecated
    public ZuulEvent setAttribute(String key, String value) {
        return this.set(key, value);
    }

    public ZuulEvent set(String key, Object value) {
        try {
            this.json.put(key, value);
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public Object get(String key) {
        if (!this.has(key)) {
            return null;
        }
        try {
            return this.json.get(key);
        }
        catch (JSONException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean has(String key) {
        return this.json.has(key);
    }

    public Iterator keys() {
        return this.json.keys();
    }

    public JSONObject toJson() {
        return this.json;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Iterator i = this.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object val = this.get(key);
            if (val == null) continue;
            m.put(key, val);
        }
        return m;
    }

    public Map<String, String> toStringMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        Iterator i = this.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object val = this.get(key);
            if (val == null) continue;
            m.put(key, val.toString());
        }
        return m;
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.json);
    }
}

