/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.zuul.stats.monitoring.NamedCount;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class RouteStatusCodeMonitor
implements NamedCount {
    @MonitorTags
    TagList tagList;
    String route_code;
    String route;
    int status_code;
    @Monitor(name="count", type=DataSourceType.COUNTER)
    private final AtomicLong count = new AtomicLong();

    public RouteStatusCodeMonitor(String route, int status_code) {
        if (route == null) {
            route = "";
        }
        this.route = route;
        this.status_code = status_code;
        this.route_code = route + "_" + status_code;
        this.tagList = BasicTagList.of((Tag[])new Tag[]{new BasicTag("ID", this.route_code)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteStatusCodeMonitor statsData = (RouteStatusCodeMonitor)o;
        if (this.status_code != statsData.status_code) {
            return false;
        }
        return !(this.route != null ? !this.route.equals(statsData.route) : statsData.route != null);
    }

    public int hashCode() {
        int result = this.route != null ? this.route.hashCode() : 0;
        result = 31 * result + this.status_code;
        return result;
    }

    @Override
    public String getName() {
        return this.route_code;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    public void update() {
        this.count.incrementAndGet();
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testUpdateStats() {
            RouteStatusCodeMonitor sd = new RouteStatusCodeMonitor("test", 200);
            Assert.assertEquals((Object)sd.route, (Object)"test");
            sd.update();
            Assert.assertEquals((long)sd.count.get(), (long)1L);
            sd.update();
            Assert.assertEquals((long)sd.count.get(), (long)2L);
        }

        @Test
        public void testEquals() {
            RouteStatusCodeMonitor sd = new RouteStatusCodeMonitor("test", 200);
            RouteStatusCodeMonitor sd1 = new RouteStatusCodeMonitor("test", 200);
            RouteStatusCodeMonitor sd2 = new RouteStatusCodeMonitor("test1", 200);
            RouteStatusCodeMonitor sd3 = new RouteStatusCodeMonitor("test", 201);
            Assert.assertTrue((boolean)sd.equals(sd1));
            Assert.assertTrue((boolean)sd1.equals(sd));
            Assert.assertTrue((boolean)sd.equals(sd));
            Assert.assertFalse((boolean)sd.equals(sd2));
            Assert.assertFalse((boolean)sd.equals(sd3));
            Assert.assertFalse((boolean)sd2.equals(sd3));
        }
    }
}

