/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.plugins;

import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.FileMetricObserver;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricPoller {
    private static Logger LOG = LoggerFactory.getLogger(MetricPoller.class);
    static final PollScheduler scheduler = PollScheduler.getInstance();

    public static void startPoller() {
        File metricsDir;
        scheduler.start();
        int heartbeatInterval = 1200;
        try {
            metricsDir = File.createTempFile("zuul-servo-metrics-", "");
            metricsDir.delete();
            metricsDir.mkdir();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.debug("created metrics dir " + metricsDir.getAbsolutePath());
        CounterToRateMetricTransform transform = new CounterToRateMetricTransform((MetricObserver)new FileMetricObserver("ZuulMetrics", metricsDir), 1200L, TimeUnit.SECONDS);
        PollRunnable task = new PollRunnable((com.netflix.servo.publish.MetricPoller)new MonitorRegistryMetricPoller(), BasicMetricFilter.MATCH_ALL, new MetricObserver[]{transform});
        int samplingInterval = 10;
        scheduler.addPoller(task, 10L, TimeUnit.SECONDS);
    }
}

