/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.passport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.collect.Sets;
import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.passport.CountingCurrentPassport;
import com.netflix.zuul.passport.PassportItem;
import com.netflix.zuul.passport.PassportState;
import com.netflix.zuul.passport.StartAndEnd;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CurrentPassport {
    private static final CachedDynamicBooleanProperty COUNT_STATES = new CachedDynamicBooleanProperty("zuul.passport.count.enabled", false);
    public static final AttributeKey<CurrentPassport> CHANNEL_ATTR = AttributeKey.newInstance((String)"_current_passport");
    private static final Ticker SYSTEM_TICKER = Ticker.systemTicker();
    private static final Set<PassportState> CONTENT_STATES = Sets.newHashSet((Object[])new PassportState[]{PassportState.IN_REQ_CONTENT_RECEIVED, PassportState.IN_RESP_CONTENT_RECEIVED, PassportState.OUT_REQ_CONTENT_SENDING, PassportState.OUT_REQ_CONTENT_SENT, PassportState.OUT_RESP_CONTENT_SENDING, PassportState.OUT_RESP_CONTENT_SENT});
    private static final CachedDynamicBooleanProperty CONTENT_STATE_ENABLED = new CachedDynamicBooleanProperty("zuul.passport.state.content.enabled", false);
    private final Ticker ticker;
    private final LinkedList<PassportItem> history;
    private final HashSet<PassportState> statesAdded;
    private final long creationTimeSinceEpochMs;

    CurrentPassport() {
        this(SYSTEM_TICKER);
    }

    @VisibleForTesting
    public CurrentPassport(Ticker ticker) {
        this.ticker = ticker;
        this.history = new LinkedList();
        this.statesAdded = new HashSet();
        this.creationTimeSinceEpochMs = System.currentTimeMillis();
    }

    public static CurrentPassport create() {
        if (COUNT_STATES.get()) {
            return new CountingCurrentPassport();
        }
        return new CurrentPassport();
    }

    public static CurrentPassport fromSessionContext(SessionContext ctx) {
        return (CurrentPassport)ctx.get("_passport");
    }

    public static CurrentPassport createForChannel(Channel ch) {
        CurrentPassport passport = CurrentPassport.create();
        passport.setOnChannel(ch);
        return passport;
    }

    public static CurrentPassport fromChannel(Channel ch) {
        CurrentPassport passport = CurrentPassport.fromChannelOrNull(ch);
        if (passport == null) {
            passport = CurrentPassport.create();
            ch.attr(CHANNEL_ATTR).set((Object)passport);
        }
        return passport;
    }

    public static CurrentPassport fromChannelOrNull(Channel ch) {
        return (CurrentPassport)ch.attr(CHANNEL_ATTR).get();
    }

    public void setOnChannel(Channel ch) {
        ch.attr(CHANNEL_ATTR).set((Object)this);
    }

    public static void clearFromChannel(Channel ch) {
        ch.attr(CHANNEL_ATTR).set(null);
    }

    public PassportState getState() {
        return this.history.peekLast().getState();
    }

    public LinkedList<PassportItem> getHistory() {
        return this.history;
    }

    public void add(PassportState state) {
        if (!CONTENT_STATE_ENABLED.get() && CONTENT_STATES.contains((Object)state)) {
            return;
        }
        this.history.addLast(new PassportItem(state, this.now()));
        this.statesAdded.add(state);
    }

    public void addIfNotAlready(PassportState state) {
        if (!this.statesAdded.contains((Object)state)) {
            this.add(state);
        }
    }

    public long calculateTimeBetweenFirstAnd(PassportState endState) {
        long startTime = this.firstTime();
        for (PassportItem item : this.history) {
            if (item.getState() != endState) continue;
            return item.getTime() - startTime;
        }
        return this.now() - startTime;
    }

    public long firstTime() {
        return this.history.getFirst().getTime();
    }

    public long creationTimeSinceEpochMs() {
        return this.creationTimeSinceEpochMs;
    }

    public long calculateTimeBetween(StartAndEnd sae) {
        if (sae.startNotFound() || sae.endNotFound()) {
            return 0L;
        }
        return sae.endTime - sae.startTime;
    }

    public long calculateTimeBetweenButIfNoEndThenUseNow(StartAndEnd sae) {
        if (sae.startNotFound()) {
            return 0L;
        }
        if (sae.endNotFound()) {
            sae.endTime = this.now();
        }
        return sae.endTime - sae.startTime;
    }

    public StartAndEnd findStartAndEndStates(PassportState startState, PassportState endState) {
        StartAndEnd sae = new StartAndEnd();
        for (PassportItem item : this.history) {
            if (item.getState() == startState) {
                sae.startTime = item.getTime();
                continue;
            }
            if (item.getState() != endState) continue;
            sae.endTime = item.getTime();
        }
        return sae;
    }

    public StartAndEnd findFirstStartAndLastEndStates(PassportState startState, PassportState endState) {
        StartAndEnd sae = new StartAndEnd();
        for (PassportItem item : this.history) {
            if (sae.startNotFound() && item.getState() == startState) {
                sae.startTime = item.getTime();
                continue;
            }
            if (item.getState() != endState) continue;
            sae.endTime = item.getTime();
        }
        return sae;
    }

    public StartAndEnd findLastStartAndFirstEndStates(PassportState startState, PassportState endState) {
        StartAndEnd sae = new StartAndEnd();
        for (PassportItem item : this.history) {
            if (item.getState() == startState) {
                sae.startTime = item.getTime();
                continue;
            }
            if (!sae.endNotFound() || item.getState() != endState) continue;
            sae.endTime = item.getTime();
        }
        return sae;
    }

    public List<StartAndEnd> findEachPairOf(PassportState startState, PassportState endState) {
        ArrayList<StartAndEnd> items = new ArrayList<StartAndEnd>();
        StartAndEnd currentPair = null;
        for (PassportItem item : this.history) {
            if (item.getState() == startState) {
                if (currentPair != null) continue;
                currentPair = new StartAndEnd();
                currentPair.startTime = item.getTime();
                continue;
            }
            if (item.getState() != endState || currentPair == null) continue;
            currentPair.endTime = item.getTime();
            items.add(currentPair);
            currentPair = null;
        }
        return items;
    }

    public PassportItem findState(PassportState state) {
        for (PassportItem item : this.history) {
            if (item.getState() != state) continue;
            return item;
        }
        return null;
    }

    public PassportItem findStateBackwards(PassportState state) {
        Iterator<PassportItem> itr = this.history.descendingIterator();
        while (itr.hasNext()) {
            PassportItem item = itr.next();
            if (item.getState() != state) continue;
            return item;
        }
        return null;
    }

    public List<PassportItem> findStates(PassportState state) {
        ArrayList<PassportItem> items = new ArrayList<PassportItem>();
        for (PassportItem item : this.history) {
            if (item.getState() != state) continue;
            items.add(item);
        }
        return items;
    }

    public List<Long> findTimes(PassportState state) {
        long startTick = this.firstTime();
        ArrayList<Long> items = new ArrayList<Long>();
        for (PassportItem item : this.history) {
            if (item.getState() != state) continue;
            items.add(item.getTime() - startTick);
        }
        return items;
    }

    public boolean wasProxyAttempt() {
        return this.findState(PassportState.OUT_REQ_HEADERS_SENDING) != null;
    }

    private long now() {
        return this.ticker.read();
    }

    public String toString() {
        long startTime = this.history.size() > 0 ? this.firstTime() : 0L;
        long now = this.now();
        StringBuilder sb = new StringBuilder();
        sb.append("CurrentPassport {");
        sb.append("start_ms=").append(this.creationTimeSinceEpochMs()).append(", ");
        sb.append('[');
        for (PassportItem item : this.history) {
            sb.append('+').append(item.getTime() - startTime).append('=').append(item.getState().name()).append(", ");
        }
        sb.append('+').append(now - startTime).append('=').append("NOW");
        sb.append(']');
        sb.append('}');
        return sb.toString();
    }

    @VisibleForTesting
    public static CurrentPassport parseFromToString(String text) {
        CurrentPassport passport = null;
        Pattern ptn = Pattern.compile("CurrentPassport \\{start_ms=\\d+, \\[(.*)\\]\\}");
        Pattern ptnState = Pattern.compile("^\\+(\\d+)=(.+)$");
        Matcher m = ptn.matcher(text);
        if (m.matches()) {
            String[] stateStrs = m.group(1).split(", ");
            MockTicker ticker = new MockTicker();
            passport = new CurrentPassport(ticker);
            for (String stateStr : stateStrs) {
                Matcher stateMatch = ptnState.matcher(stateStr);
                if (!stateMatch.matches()) continue;
                String stateName = stateMatch.group(2);
                if (stateName.equals("NOW")) {
                    long startTime = passport.getHistory().size() > 0 ? passport.firstTime() : 0L;
                    long now = Long.valueOf(stateMatch.group(1)) + startTime;
                    ticker.setNow(now);
                    continue;
                }
                PassportState state = PassportState.valueOf(stateName);
                PassportItem item = new PassportItem(state, Long.valueOf(stateMatch.group(1)));
                passport.getHistory().add(item);
            }
        }
        return passport;
    }

    private static class MockTicker
    extends Ticker {
        private long now = -1L;

        private MockTicker() {
        }

        public long read() {
            if (this.now == -1L) {
                throw new IllegalStateException();
            }
            return this.now;
        }

        public void setNow(long now) {
            this.now = now;
        }
    }
}

