/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.ssl;

import com.netflix.netty.common.ssl.ServerSslConfig;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.netty.ssl.BaseSslContextFactory;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSslContextFactory
extends BaseSslContextFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientSslContextFactory.class);
    private static final ServerSslConfig DEFAULT_CONFIG = new ServerSslConfig(new String[]{"TLSv1.2"}, ServerSslConfig.getDefaultCiphers(), null, null);

    public ClientSslContextFactory(Registry spectatorRegistry) {
        super(spectatorRegistry, DEFAULT_CONFIG);
    }

    public ClientSslContextFactory(Registry spectatorRegistry, ServerSslConfig serverSslConfig) {
        super(spectatorRegistry, serverSslConfig);
    }

    public SslContext getClientSslContext() {
        try {
            return SslContextBuilder.forClient().sslProvider(ClientSslContextFactory.chooseSslProvider()).ciphers(this.getCiphers(), this.getCiphersFilter()).protocols(this.getProtocols()).build();
        }
        catch (Exception e) {
            log.error("Error loading SslContext client request.", (Throwable)e);
            throw new RuntimeException("Error configuring SslContext for client request!", e);
        }
    }
}

