/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.ssl;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.netty.common.ssl.ServerSslConfig;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.netty.ssl.SslContextFactory;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSslContextFactory
implements SslContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BaseSslContextFactory.class);
    private static final DynamicBooleanProperty ALLOW_USE_OPENSSL = new DynamicBooleanProperty("zuul.ssl.openssl.allow", true);
    protected final Registry spectatorRegistry;
    protected final ServerSslConfig serverSslConfig;

    public BaseSslContextFactory(Registry spectatorRegistry, ServerSslConfig serverSslConfig) {
        this.spectatorRegistry = spectatorRegistry;
        this.serverSslConfig = serverSslConfig;
    }

    @Override
    public SslContextBuilder createBuilderForServer() {
        try {
            ArrayList<X509Certificate> trustedCerts = this.getTrustedX509Certificates();
            SslProvider sslProvider = BaseSslContextFactory.chooseSslProvider();
            LOG.warn("Using SslProvider of type - " + sslProvider.name() + " for certChainFile - " + this.serverSslConfig.getCertChainFile());
            FileInputStream certChainInput = new FileInputStream(this.serverSslConfig.getCertChainFile());
            InputStream keyInput = this.getKeyInputStream();
            SslContextBuilder builder = SslContextBuilder.forServer((InputStream)certChainInput, (InputStream)keyInput).ciphers(this.getCiphers(), this.getCiphersFilter()).sessionTimeout(this.serverSslConfig.getSessionTimeout()).sslProvider(sslProvider);
            if (this.serverSslConfig.getClientAuth() != null && CollectionUtils.isNotEmpty(trustedCerts)) {
                builder = builder.trustManager(trustedCerts.toArray(new X509Certificate[0])).clientAuth(this.serverSslConfig.getClientAuth());
            }
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException("Error configuring SslContext!", e);
        }
    }

    @Override
    public void enableSessionTickets(SslContext sslContext) {
    }

    @Override
    public void configureOpenSslStatsMetrics(SslContext sslContext, String sslContextId) {
        if (sslContext instanceof ReferenceCountedOpenSslContext) {
            OpenSslSessionStats stats = ((ReferenceCountedOpenSslContext)sslContext).sessionContext().stats();
            this.openSslStatGauge(stats, sslContextId, "accept", OpenSslSessionStats::accept);
            this.openSslStatGauge(stats, sslContextId, "accept_good", OpenSslSessionStats::acceptGood);
            this.openSslStatGauge(stats, sslContextId, "accept_renegotiate", OpenSslSessionStats::acceptRenegotiate);
            this.openSslStatGauge(stats, sslContextId, "number", OpenSslSessionStats::number);
            this.openSslStatGauge(stats, sslContextId, "connect", OpenSslSessionStats::connect);
            this.openSslStatGauge(stats, sslContextId, "connect_good", OpenSslSessionStats::connectGood);
            this.openSslStatGauge(stats, sslContextId, "connect_renegotiate", OpenSslSessionStats::connectRenegotiate);
            this.openSslStatGauge(stats, sslContextId, "hits", OpenSslSessionStats::hits);
            this.openSslStatGauge(stats, sslContextId, "cb_hits", OpenSslSessionStats::cbHits);
            this.openSslStatGauge(stats, sslContextId, "misses", OpenSslSessionStats::misses);
            this.openSslStatGauge(stats, sslContextId, "timeouts", OpenSslSessionStats::timeouts);
            this.openSslStatGauge(stats, sslContextId, "cache_full", OpenSslSessionStats::cacheFull);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_fail", OpenSslSessionStats::ticketKeyFail);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_new", OpenSslSessionStats::ticketKeyNew);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_renew", OpenSslSessionStats::ticketKeyRenew);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_resume", OpenSslSessionStats::ticketKeyResume);
        }
    }

    private void openSslStatGauge(OpenSslSessionStats stats, String sslContextId, String statName, ToDoubleFunction<OpenSslSessionStats> value) {
        Id id = this.spectatorRegistry.createId("server.ssl.stats", new String[]{"id", sslContextId, "stat", statName});
        this.spectatorRegistry.gauge(id, (Object)stats, value);
        LOG.debug("Registered spectator gauge - " + id.name());
    }

    public static SslProvider chooseSslProvider() {
        SslProvider sslProvider = ALLOW_USE_OPENSSL.get() && OpenSsl.isAvailable() && OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
        return sslProvider;
    }

    public ServerSslConfig getServerSslConfig() {
        return this.serverSslConfig;
    }

    @Override
    public String[] getProtocols() {
        return this.serverSslConfig.getProtocols();
    }

    @Override
    public List<String> getCiphers() throws NoSuchAlgorithmException {
        return this.serverSslConfig.getCiphers();
    }

    protected CipherSuiteFilter getCiphersFilter() {
        return SupportedCipherSuiteFilter.INSTANCE;
    }

    protected ArrayList<X509Certificate> getTrustedX509Certificates() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        if (this.serverSslConfig.getClientAuth() == ClientAuth.REQUIRE || this.serverSslConfig.getClientAuth() == ClientAuth.OPTIONAL) {
            byte[] trustStorePwdBytes;
            if (this.serverSslConfig.getClientAuthTrustStorePassword() != null) {
                trustStorePwdBytes = Base64.getDecoder().decode(this.serverSslConfig.getClientAuthTrustStorePassword());
            } else if (this.serverSslConfig.getClientAuthTrustStorePasswordFile() != null) {
                trustStorePwdBytes = FileUtils.readFileToByteArray((File)this.serverSslConfig.getClientAuthTrustStorePasswordFile());
            } else {
                throw new IllegalArgumentException("Must specify either ClientAuthTrustStorePassword or ClientAuthTrustStorePasswordFile!");
            }
            String trustStorePassword = this.getTruststorePassword(trustStorePwdBytes);
            boolean dumpDecryptedTrustStorePassword = false;
            if (dumpDecryptedTrustStorePassword) {
                LOG.debug("X509Cert Trust Store Password " + trustStorePassword);
            }
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(new FileInputStream(this.serverSslConfig.getClientAuthTrustStoreFile()), trustStorePassword.toCharArray());
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert = (X509Certificate)trustStore.getCertificate(aliases.nextElement());
                trustedCerts.add(cert);
            }
        }
        return trustedCerts;
    }

    protected String getTruststorePassword(byte[] trustStorePwdBytes) {
        return new String(trustStorePwdBytes).trim();
    }

    protected InputStream getKeyInputStream() throws IOException {
        return new FileInputStream(this.serverSslConfig.getKeyFile());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

