/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.push;

import com.google.common.base.Charsets;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.zuul.netty.server.push.PushProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;

public class PushConnection {
    private final PushProtocol pushProtocol;
    private final ChannelHandlerContext ctx;
    private String secureToken;
    private double tkBktAllowance;
    private long tkBktLastCheckTime;
    public static final CachedDynamicIntProperty TOKEN_BUCKET_RATE = new CachedDynamicIntProperty("zuul.push.tokenBucket.rate", 3);
    public static final CachedDynamicIntProperty TOKEN_BUCKET_WINDOW = new CachedDynamicIntProperty("zuul.push.tokenBucket.window.millis", 2000);

    public PushConnection(PushProtocol pushProtocol, ChannelHandlerContext ctx) {
        this.pushProtocol = pushProtocol;
        this.ctx = ctx;
        this.tkBktAllowance = TOKEN_BUCKET_RATE.get();
        this.tkBktLastCheckTime = System.currentTimeMillis();
    }

    public String getSecureToken() {
        return this.secureToken;
    }

    public void setSecureToken(String secureToken) {
        this.secureToken = secureToken;
    }

    public synchronized boolean isRateLimited() {
        double rate = TOKEN_BUCKET_RATE.get();
        double window = TOKEN_BUCKET_WINDOW.get();
        long current = System.currentTimeMillis();
        double timePassed = current - this.tkBktLastCheckTime;
        this.tkBktLastCheckTime = current;
        this.tkBktAllowance += timePassed * (rate / window);
        if (this.tkBktAllowance > rate) {
            this.tkBktAllowance = rate;
        }
        if (this.tkBktAllowance < 1.0) {
            return true;
        }
        this.tkBktAllowance -= 1.0;
        return false;
    }

    public ChannelFuture sendPushMessage(ByteBuf mesg) {
        return this.pushProtocol.sendPushMessage(this.ctx, mesg);
    }

    public ChannelFuture sendPushMessage(String mesg) {
        return this.sendPushMessage(Unpooled.copiedBuffer((CharSequence)mesg, (Charset)Charsets.UTF_8));
    }

    public ChannelFuture sendPing() {
        return this.pushProtocol.sendPing(this.ctx);
    }
}

