/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;

@ChannelHandler.Sharable
public class Http2StreamErrorHandler
extends ChannelInboundHandlerAdapter {
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof Http2Exception.StreamException) {
            Http2Exception.StreamException streamEx = (Http2Exception.StreamException)cause;
            ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(streamEx.error()));
        } else if (cause instanceof DecoderException) {
            ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR));
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }
}

