/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.spectator.api.Counter;
import com.netflix.zuul.netty.connectionpool.ClientChannelManager;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfig;
import com.netflix.zuul.passport.CurrentPassport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnection {
    protected static final AttributeKey<PooledConnection> CHANNEL_ATTR = AttributeKey.newInstance((String)"_pooled_connection");
    public static final String READ_TIMEOUT_HANDLER_NAME = "readTimeoutHandler";
    private final Server server;
    private final Channel channel;
    private final ClientChannelManager channelManager;
    private final InstanceInfo serverKey;
    private final ServerStats serverStats;
    private final long creationTS;
    private final Counter closeConnCounter;
    private final Counter closeWrtBusyConnCounter;
    private static final Logger LOG = LoggerFactory.getLogger(PooledConnection.class);
    private ConnectionState connectionState;
    private long usageCount = 0L;
    private long reqStartTime;
    private boolean inPool = false;
    private boolean shouldClose = false;
    private boolean released = false;

    public PooledConnection(Channel channel, Server server, ClientChannelManager channelManager, InstanceInfo serverKey, ServerStats serverStats, Counter closeConnCounter, Counter closeWrtBusyConnCounter) {
        this.channel = channel;
        this.server = server;
        this.channelManager = channelManager;
        this.serverKey = serverKey;
        this.serverStats = serverStats;
        this.creationTS = System.currentTimeMillis();
        this.closeConnCounter = closeConnCounter;
        this.closeWrtBusyConnCounter = closeWrtBusyConnCounter;
        this.connectionState = ConnectionState.WRITE_READY;
        channel.attr(CHANNEL_ATTR).set((Object)this);
    }

    public void setInUse() {
        this.connectionState = ConnectionState.WRITE_BUSY;
        this.released = false;
    }

    public void setConnectionState(ConnectionState state) {
        this.connectionState = state;
    }

    public static PooledConnection getFromChannel(Channel ch) {
        return (PooledConnection)ch.attr(CHANNEL_ATTR).get();
    }

    public ConnectionPoolConfig getConfig() {
        return this.channelManager.getConfig();
    }

    public Server getServer() {
        return this.server;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public InstanceInfo getServerKey() {
        return this.serverKey;
    }

    public long getUsageCount() {
        return this.usageCount;
    }

    public void incrementUsageCount() {
        ++this.usageCount;
    }

    public long getCreationTS() {
        return this.creationTS;
    }

    public long getAgeInMillis() {
        return System.currentTimeMillis() - this.creationTS;
    }

    public ServerStats getServerStats() {
        return this.serverStats;
    }

    public void startRequestTimer() {
        this.reqStartTime = System.nanoTime();
    }

    public long stopRequestTimer() {
        long responseTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.reqStartTime);
        this.serverStats.noteResponseTime((double)responseTime);
        return responseTime;
    }

    public boolean isActive() {
        return this.channel.isActive() && this.channel.isRegistered();
    }

    public boolean isInPool() {
        return this.inPool;
    }

    public void setInPool(boolean inPool) {
        this.inPool = inPool;
    }

    public boolean isShouldClose() {
        return this.shouldClose;
    }

    public void flagShouldClose() {
        this.shouldClose = true;
    }

    public ChannelFuture close() {
        ServerStats stats = this.getServerStats();
        stats.decrementOpenConnectionsCount();
        this.closeConnCounter.increment();
        return this.channel.close();
    }

    public void updateServerStats() {
        ServerStats stats = this.getServerStats();
        stats.decrementOpenConnectionsCount();
        stats.close();
    }

    public ChannelFuture closeAndRemoveFromPool() {
        this.channelManager.remove(this);
        return this.close();
    }

    public void release() {
        if (this.released) {
            return;
        }
        if (this.isActive() && this.connectionState != ConnectionState.WRITE_READY) {
            this.closeWrtBusyConnCounter.increment();
        }
        if (!this.isShouldClose() && this.connectionState != ConnectionState.WRITE_READY) {
            CurrentPassport passport = CurrentPassport.fromChannel(this.channel);
            LOG.info("Error - Attempt to put busy connection into the pool = " + this.toString() + ", " + String.valueOf(passport));
            this.shouldClose = true;
        }
        this.connectionState = ConnectionState.WRITE_READY;
        this.released = true;
        this.channelManager.release(this);
    }

    public void removeReadTimeoutHandler() {
        ChannelPipeline pipeline = this.getChannel().pipeline();
        this.removeHandlerFromPipeline(READ_TIMEOUT_HANDLER_NAME, pipeline);
    }

    private void removeHandlerFromPipeline(String handlerName, ChannelPipeline pipeline) {
        if (pipeline.get(handlerName) != null) {
            pipeline.remove(handlerName);
        }
    }

    public void startReadTimeoutHandler(int readTimeout) {
        this.channel.pipeline().addBefore("originNettyLogger", READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler((long)readTimeout, TimeUnit.MILLISECONDS));
    }

    public String toString() {
        return "PooledConnection{channel=" + this.channel + ", serverKey=" + this.serverKey + ", usageCount=" + this.usageCount + '}';
    }

    public static enum ConnectionState {
        WRITE_READY,
        WRITE_BUSY;

    }
}

