/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.netflix.zuul.message.Header;
import com.netflix.zuul.message.HeaderName;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.util.HttpUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class Headers
implements Cloneable {
    private final ListMultimap<HeaderName, String> delegate;
    private final boolean immutable;

    public Headers() {
        this.delegate = ArrayListMultimap.create();
        this.immutable = false;
    }

    private Headers(ListMultimap<HeaderName, String> delegate) {
        this.delegate = delegate;
        this.immutable = ImmutableListMultimap.class.isAssignableFrom(delegate.getClass());
    }

    protected HeaderName getHeaderName(String name) {
        return HttpHeaderNames.get(name);
    }

    private boolean delegatePut(HeaderName hn, String value) {
        return this.delegate.put((Object)hn, (Object)HttpUtils.stripMaliciousHeaderChars(value));
    }

    private void delegatePutAll(Headers headers) {
        headers.delegate.entries().forEach(entry -> this.delegatePut((HeaderName)entry.getKey(), (String)entry.getValue()));
    }

    public String getFirst(String name) {
        HeaderName hn = this.getHeaderName(name);
        return this.getFirst(hn);
    }

    public String getFirst(HeaderName hn) {
        List values = this.delegate.get((Object)hn);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public String getFirst(String name, String defaultValue) {
        String value = this.getFirst(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getFirst(HeaderName hn, String defaultValue) {
        String value = this.getFirst(hn);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public List<String> get(String name) {
        HeaderName hn = this.getHeaderName(name);
        return this.get(hn);
    }

    public List<String> get(HeaderName hn) {
        return this.delegate.get((Object)hn);
    }

    public void set(String name, String value) {
        HeaderName hn = this.getHeaderName(name);
        this.set(hn, value);
    }

    public void set(HeaderName hn, String value) {
        this.delegate.removeAll((Object)hn);
        if (value != null) {
            this.delegatePut(hn, value);
        }
    }

    public boolean setIfAbsent(String name, String value) {
        HeaderName hn = this.getHeaderName(name);
        return this.setIfAbsent(hn, value);
    }

    public boolean setIfAbsent(HeaderName hn, String value) {
        boolean did = false;
        if (!this.contains(hn)) {
            this.set(hn, value);
            did = true;
        }
        return did;
    }

    public void add(String name, String value) {
        HeaderName hn = this.getHeaderName(name);
        this.add(hn, value);
    }

    public void add(HeaderName hn, String value) {
        this.delegatePut(hn, value);
    }

    public void putAll(Headers headers) {
        this.delegatePutAll(headers);
    }

    public List<String> remove(String name) {
        HeaderName hn = this.getHeaderName(name);
        return this.remove(hn);
    }

    public List<String> remove(HeaderName hn) {
        return this.delegate.removeAll((Object)hn);
    }

    public boolean removeIf(Predicate<? super Map.Entry<HeaderName, String>> filter) {
        return this.delegate.entries().removeIf(filter);
    }

    public Collection<Header> entries() {
        return this.delegate.entries().stream().map(entry -> new Header((HeaderName)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    public Set<HeaderName> keySet() {
        return this.delegate.keySet();
    }

    public boolean contains(String name) {
        return this.contains(this.getHeaderName(name));
    }

    public boolean contains(HeaderName hn) {
        return this.delegate.containsKey((Object)hn);
    }

    public boolean contains(String name, String value) {
        HeaderName hn = this.getHeaderName(name);
        return this.contains(hn, value);
    }

    public boolean contains(HeaderName hn, String value) {
        return this.delegate.containsEntry((Object)hn, (Object)value);
    }

    public int size() {
        return this.delegate.size();
    }

    public Headers clone() {
        Headers copy = new Headers();
        copy.delegatePutAll(this);
        return copy;
    }

    public Headers immutableCopy() {
        return new Headers((ListMultimap<HeaderName, String>)ImmutableListMultimap.copyOf(this.delegate));
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Headers)) {
            return false;
        }
        Headers h2 = (Headers)obj;
        return Iterables.elementsEqual((Iterable)this.delegate.entries(), (Iterable)h2.delegate.entries());
    }

    public String toString() {
        return this.delegate.toString();
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testCaseInsensitiveKeys_Set() {
            Headers headers = new Headers();
            headers.set("Content-Length", "5");
            headers.set("content-length", "10");
            Assert.assertEquals((Object)"10", (Object)headers.getFirst("Content-Length"));
            Assert.assertEquals((Object)"10", (Object)headers.getFirst("content-length"));
            Assert.assertEquals((long)1L, (long)headers.get("content-length").size());
        }

        @Test
        public void testCaseInsensitiveKeys_Add() {
            Headers headers = new Headers();
            headers.add("Content-Length", "5");
            headers.add("content-length", "10");
            List<String> values = headers.get("content-length");
            Assert.assertTrue((boolean)values.contains("10"));
            Assert.assertTrue((boolean)values.contains("5"));
            Assert.assertEquals((long)2L, (long)values.size());
        }

        @Test
        public void testCaseInsensitiveKeys_SetIfAbsent() {
            Headers headers = new Headers();
            headers.set("Content-Length", "5");
            headers.setIfAbsent("content-length", "10");
            List<String> values = headers.get("content-length");
            Assert.assertEquals((long)1L, (long)values.size());
            Assert.assertEquals((Object)"5", (Object)values.get(0));
        }

        @Test
        public void testCaseInsensitiveKeys_PutAll() {
            Headers headers = new Headers();
            headers.add("Content-Length", "5");
            headers.add("content-length", "10");
            Headers headers2 = new Headers();
            headers2.putAll(headers);
            List<String> values = headers2.get("content-length");
            Assert.assertTrue((boolean)values.contains("10"));
            Assert.assertTrue((boolean)values.contains("5"));
            Assert.assertEquals((long)2L, (long)values.size());
        }
    }
}

