/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.logging;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class FilteredPatternLayout
extends PatternLayout {
    private Set<String> filteredFrames = new HashSet<String>();
    private String header;
    private String footer;
    private static String lineSeparator = "\n";
    private static final String FILTERED_LINE_INDICATOR = "\t... filtered lines = ";

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public String format(LoggingEvent event) {
        String result = super.format(event);
        ThrowableInformation throwableInformation = event.getThrowableInformation();
        if (throwableInformation != null) {
            result = result + this.getFilteredStacktrace(throwableInformation);
        }
        return result;
    }

    public void setFilters(String filters) {
        for (String filter : filters.split(",")) {
            this.filteredFrames.add("at " + filter.trim());
        }
    }

    private String getFilteredStacktrace(ThrowableInformation throwableInformation) {
        StringBuffer buffer = new StringBuffer();
        String[] s = throwableInformation.getThrowableStrRep();
        boolean previousLineWasAMatch = false;
        int consecutiveFilteredCount = 0;
        for (int j = 0; j < s.length; ++j) {
            String string = s[j];
            boolean shouldAppend = true;
            if (this.startsWithAFilteredPAttern(string)) {
                shouldAppend = false;
                previousLineWasAMatch = true;
                ++consecutiveFilteredCount;
            } else {
                this.appendFilteredLineIndicator(buffer, previousLineWasAMatch, consecutiveFilteredCount);
                consecutiveFilteredCount = 0;
                previousLineWasAMatch = false;
            }
            if (!shouldAppend) continue;
            buffer.append(string);
            buffer.append(lineSeparator);
        }
        this.appendFilteredLineIndicator(buffer, previousLineWasAMatch, consecutiveFilteredCount);
        return buffer.toString();
    }

    private void appendFilteredLineIndicator(StringBuffer buffer, boolean previousLineWasAMatch, int consecutiveFilteredCount) {
        if (previousLineWasAMatch) {
            buffer.append(FILTERED_LINE_INDICATOR).append(consecutiveFilteredCount);
            buffer.append(lineSeparator);
        }
    }

    private boolean startsWithAFilteredPAttern(String string) {
        Iterator<String> iterator = this.filteredFrames.iterator();
        while (iterator.hasNext()) {
            if (!string.trim().startsWith(iterator.next())) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            lineSeparator = System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

