/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.reflect.ClassPath;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.netflix.config.ConfigurationManager;
import com.netflix.zuul.BasicFilterUsageNotifier;
import com.netflix.zuul.DynamicCodeCompiler;
import com.netflix.zuul.FilterFactory;
import com.netflix.zuul.FilterFileManager;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.groovy.GroovyCompiler;
import com.netflix.zuul.guice.GuiceFilterFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZuulFiltersModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ZuulFiltersModule.class);
    private static Predicate<String> blank = String::isEmpty;

    protected void configure() {
        LOG.info("Starting Groovy Filter file manager");
        this.bind(DynamicCodeCompiler.class).to(GroovyCompiler.class);
        this.bind(FilterFactory.class).to(GuiceFilterFactory.class);
        this.bind(FilterUsageNotifier.class).to(BasicFilterUsageNotifier.class);
        LOG.info("Groovy Filter file manager started");
    }

    @Provides
    FilterFileManager.FilterFileManagerConfig provideFilterFileManagerConfig() {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        String[] filterLocations = this.findFilterLocations(config);
        String[] filterClassNames = this.findClassNames(config);
        FilterFileManager.FilterFileManagerConfig filterConfig = new FilterFileManager.FilterFileManagerConfig(filterLocations, filterClassNames, 5);
        return filterConfig;
    }

    @VisibleForTesting
    String[] findClassNames(AbstractConfiguration config) {
        ClassPath cp;
        String[] filterClassNamesStrArray = config.getStringArray("zuul.filters.classes");
        Stream<String> classNameStream = Arrays.stream(filterClassNamesStrArray).map(String::trim).filter(blank.negate());
        String[] packageNamesStrArray = config.getStringArray("zuul.filters.packages");
        try {
            cp = ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException("Error attempting to read classpath to find filters!", e);
        }
        Stream<String> packageStream = Arrays.stream(packageNamesStrArray).map(String::trim).filter(blank.negate()).flatMap(packageName -> cp.getTopLevelClasses(packageName).stream()).map(ClassPath.ClassInfo::load).filter(ZuulFilter.class::isAssignableFrom).map(Class::getCanonicalName);
        String[] filterClassNames = (String[])Stream.concat(classNameStream, packageStream).toArray(String[]::new);
        if (filterClassNames.length != 0) {
            LOG.info("Using filter classnames: ");
            for (String location : filterClassNames) {
                LOG.info("  " + location);
            }
        }
        return filterClassNames;
    }

    @VisibleForTesting
    String[] findFilterLocations(AbstractConfiguration config) {
        String[] filterLocations;
        String[] locations = config.getStringArray("zuul.filters.locations");
        if (locations == null) {
            locations = new String[]{"inbound", "outbound", "endpoint"};
        }
        if ((filterLocations = (String[])Arrays.stream(locations).map(String::trim).filter(blank.negate()).toArray(String[]::new)).length != 0) {
            LOG.info("Using filter locations: ");
            for (String location : filterLocations) {
                LOG.info("  " + location);
            }
        }
        return filterLocations;
    }
}

