/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters;

import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.spectator.api.Counter;
import com.netflix.zuul.exception.ZuulFilterConcurrencyExceededException;
import com.netflix.zuul.filters.BaseSyncFilter;
import com.netflix.zuul.filters.FilterSyncType;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.netty.SpectatorUtils;
import io.netty.handler.codec.http.HttpContent;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class BaseFilter<I extends ZuulMessage, O extends ZuulMessage>
implements ZuulFilter<I, O> {
    private final String baseName = this.getClass().getSimpleName() + "." + this.filterType().toString();
    private final AtomicInteger concurrentCount = SpectatorUtils.newGauge("zuul.filter.concurrency.current", this.baseName, new AtomicInteger(0));
    private final Counter concurrencyRejections = SpectatorUtils.newCounter("zuul.filter.concurrency.rejected", this.baseName);
    private final CachedDynamicBooleanProperty filterDisabled = new CachedDynamicBooleanProperty(this.disablePropertyName(), false);
    private final CachedDynamicIntProperty filterConcurrencyLimit = new CachedDynamicIntProperty(this.maxConcurrencyPropertyName(), 4000);
    private static final CachedDynamicBooleanProperty concurrencyProtectEnabled = new CachedDynamicBooleanProperty("zuul.filter.concurrency.protect.enabled", true);

    protected BaseFilter() {
    }

    @Override
    public String filterName() {
        return this.getClass().getName();
    }

    @Override
    public boolean overrideStopFilterProcessing() {
        return false;
    }

    public String disablePropertyName() {
        return "zuul." + this.baseName + ".disable";
    }

    public String maxConcurrencyPropertyName() {
        return "zuul." + this.baseName + ".concurrency.limit";
    }

    @Override
    public boolean isDisabled() {
        return this.filterDisabled.get();
    }

    @Override
    public O getDefaultOutput(I input) {
        return (O)input;
    }

    @Override
    public FilterSyncType getSyncType() {
        return FilterSyncType.ASYNC;
    }

    public String toString() {
        return String.valueOf((Object)this.filterType()) + ":" + String.valueOf(this.filterName());
    }

    @Override
    public boolean needsBodyBuffered(I input) {
        return false;
    }

    @Override
    public HttpContent processContentChunk(ZuulMessage zuulMessage, HttpContent chunk) {
        return chunk;
    }

    @Override
    public void incrementConcurrency() throws ZuulFilterConcurrencyExceededException {
        int limit = this.filterConcurrencyLimit.get();
        if (concurrencyProtectEnabled.get() && this.concurrentCount.get() >= limit) {
            this.concurrencyRejections.increment();
            throw new ZuulFilterConcurrencyExceededException(this, limit);
        }
        this.concurrentCount.incrementAndGet();
    }

    @Override
    public void decrementConcurrency() {
        this.concurrentCount.decrementAndGet();
    }

    public static class TestUnit {
        @Mock
        private BaseFilter f1;
        @Mock
        private BaseFilter f2;
        @Mock
        private ZuulMessage req;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testShouldFilter() {
            class TestZuulFilter
            extends BaseSyncFilter {
                TestZuulFilter() {
                }

                @Override
                public int filterOrder() {
                    return 0;
                }

                @Override
                public FilterType filterType() {
                    return FilterType.INBOUND;
                }

                @Override
                public boolean shouldFilter(ZuulMessage req) {
                    return false;
                }

                @Override
                public ZuulMessage apply(ZuulMessage req) {
                    return null;
                }
            }
            TestZuulFilter tf1 = (TestZuulFilter)Mockito.spy((Object)new TestZuulFilter());
            TestZuulFilter tf2 = (TestZuulFilter)Mockito.spy((Object)new TestZuulFilter());
            Mockito.when((Object)tf1.shouldFilter(this.req)).thenReturn((Object)true);
            Mockito.when((Object)tf2.shouldFilter(this.req)).thenReturn((Object)false);
        }
    }
}

