/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.exception;

import com.netflix.client.ClientException;
import com.netflix.zuul.exception.ErrorType;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.ZuulStatusCategory;

public enum OutboundErrorType implements ErrorType
{
    READ_TIMEOUT(ERROR_TYPE_READ_TIMEOUT_STATUS.get(), ZuulStatusCategory.FAILURE_ORIGIN_READ_TIMEOUT, ClientException.ErrorType.READ_TIMEOUT_EXCEPTION),
    CONNECT_ERROR(ERROR_TYPE_CONNECT_ERROR_STATUS.get(), ZuulStatusCategory.FAILURE_ORIGIN_CONNECTIVITY, ClientException.ErrorType.CONNECT_EXCEPTION),
    SERVICE_UNAVAILABLE(ERROR_TYPE_SERVICE_UNAVAILABLE_STATUS.get(), ZuulStatusCategory.FAILURE_ORIGIN_THROTTLED, ClientException.ErrorType.SERVER_THROTTLED),
    ERROR_STATUS_RESPONSE(ERROR_TYPE_ERROR_STATUS_RESPONSE_STATUS.get(), ZuulStatusCategory.FAILURE_ORIGIN, ClientException.ErrorType.GENERAL),
    NO_AVAILABLE_SERVERS(ERROR_TYPE_NOSERVERS_STATUS.get(), ZuulStatusCategory.FAILURE_ORIGIN_NO_SERVERS, ClientException.ErrorType.CONNECT_EXCEPTION),
    ORIGIN_SERVER_MAX_CONNS(ERROR_TYPE_ORIGIN_SERVER_MAX_CONNS_STATUS.get(), ZuulStatusCategory.FAILURE_LOCAL_THROTTLED_ORIGIN_SERVER_MAXCONN, ClientException.ErrorType.CLIENT_THROTTLED),
    RESET_CONNECTION(ERROR_TYPE_ORIGIN_RESET_CONN_STATUS.get(), ZuulStatusCategory.FAILURE_ORIGIN_RESET_CONNECTION, ClientException.ErrorType.CONNECT_EXCEPTION),
    CANCELLED(400, ZuulStatusCategory.FAILURE_CLIENT_CANCELLED, ClientException.ErrorType.SOCKET_TIMEOUT_EXCEPTION),
    ORIGIN_CONCURRENCY_EXCEEDED(ERROR_TYPE_ORIGIN_CONCURRENCY_EXCEEDED_STATUS.get(), ZuulStatusCategory.FAILURE_LOCAL_THROTTLED_ORIGIN_CONCURRENCY, ClientException.ErrorType.SERVER_THROTTLED),
    OTHER(ERROR_TYPE_OTHER_STATUS.get(), ZuulStatusCategory.FAILURE_LOCAL, ClientException.ErrorType.GENERAL);

    private static final String NAME_PREFIX = "ORIGIN_";
    private final int statusCodeToReturn;
    private final StatusCategory statusCategory;
    private final ClientException.ErrorType clientErrorType;

    private OutboundErrorType(int statusCodeToReturn, StatusCategory statusCategory, ClientException.ErrorType clientErrorType) {
        this.statusCodeToReturn = statusCodeToReturn;
        this.statusCategory = statusCategory;
        this.clientErrorType = clientErrorType;
    }

    @Override
    public int getStatusCodeToReturn() {
        return this.statusCodeToReturn;
    }

    @Override
    public StatusCategory getStatusCategory() {
        return this.statusCategory;
    }

    @Override
    public ClientException.ErrorType getClientErrorType() {
        return this.clientErrorType;
    }

    public String toString() {
        return NAME_PREFIX + this.name();
    }
}

