/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.proxyprotocol;

import com.google.common.collect.Sets;
import com.netflix.netty.common.ssl.SslHandshakeInfo;
import com.netflix.zuul.netty.server.ssl.SslHandshakeInfoHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.ClientAuth;
import io.netty.util.AsciiString;
import java.util.Collection;

@ChannelHandler.Sharable
public class StripUntrustedProxyHeadersHandler
extends ChannelInboundHandlerAdapter {
    private static final Collection<AsciiString> HEADERS_TO_STRIP = Sets.newHashSet((Object[])new AsciiString[]{new AsciiString((CharSequence)"x-forwarded-for"), new AsciiString((CharSequence)"x-forwarded-port"), new AsciiString((CharSequence)"x-forwarded-proto"), new AsciiString((CharSequence)"x-forwarded-proto-version"), new AsciiString((CharSequence)"x-real-ip")});
    private final AllowWhen allowWhen;

    public StripUntrustedProxyHeadersHandler(AllowWhen allowWhen) {
        this.allowWhen = allowWhen;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            switch (this.allowWhen) {
                case NEVER: {
                    this.stripXFFHeaders(req);
                    break;
                }
                case MUTUAL_SSL_AUTH: {
                    if (this.connectionIsUsingMutualSSLWithAuthEnforced(ctx.channel())) break;
                    this.stripXFFHeaders(req);
                    break;
                }
                case ALWAYS: {
                    break;
                }
                default: {
                    this.stripXFFHeaders(req);
                }
            }
        }
        super.channelRead(ctx, msg);
    }

    private boolean connectionIsUsingMutualSSLWithAuthEnforced(Channel ch) {
        boolean is = false;
        SslHandshakeInfo sslHandshakeInfo = (SslHandshakeInfo)ch.attr(SslHandshakeInfoHandler.ATTR_SSL_INFO).get();
        if (sslHandshakeInfo != null && sslHandshakeInfo.getClientAuthRequirement() == ClientAuth.REQUIRE) {
            is = true;
        }
        return is;
    }

    private void stripXFFHeaders(HttpRequest req) {
        HttpHeaders headers = req.headers();
        for (AsciiString headerName : HEADERS_TO_STRIP) {
            headers.remove((CharSequence)headerName);
        }
    }

    public static enum AllowWhen {
        ALWAYS,
        MUTUAL_SSL_AUTH,
        NEVER;

    }
}

