/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.netflix.netty.common.metrics.EventLoopMetrics;
import com.netflix.spectator.api.Registry;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EventLoopGroupMetrics {
    private final ThreadLocal<EventLoopMetrics> metricsForCurrentThread;
    private final Map<Thread, EventLoopMetrics> byEventLoop = new HashMap<Thread, EventLoopMetrics>();
    private final Registry registry;

    @Inject
    public EventLoopGroupMetrics(Registry registry) {
        this.registry = registry;
        this.metricsForCurrentThread = ThreadLocal.withInitial(() -> {
            String name = EventLoopGroupMetrics.nameForCurrentEventLoop();
            EventLoopMetrics metrics = new EventLoopMetrics(registry, name);
            this.byEventLoop.put(Thread.currentThread(), metrics);
            return metrics;
        });
    }

    public Map<Thread, Integer> connectionsPerEventLoop() {
        HashMap<Thread, Integer> map = new HashMap<Thread, Integer>(this.byEventLoop.size());
        for (Map.Entry<Thread, EventLoopMetrics> entry : this.byEventLoop.entrySet()) {
            map.put(entry.getKey(), entry.getValue().currentConnectionsCount());
        }
        return map;
    }

    public Map<Thread, Integer> httpRequestsPerEventLoop() {
        HashMap<Thread, Integer> map = new HashMap<Thread, Integer>(this.byEventLoop.size());
        for (Map.Entry<Thread, EventLoopMetrics> entry : this.byEventLoop.entrySet()) {
            map.put(entry.getKey(), entry.getValue().currentHttpRequestsCount());
        }
        return map;
    }

    public EventLoopMetrics getForCurrentEventLoop() {
        return this.metricsForCurrentThread.get();
    }

    private static String nameForCurrentEventLoop() {
        String threadName = Thread.currentThread().getName();
        String[] parts = threadName.split("-ClientToZuulWorker-");
        if (parts.length == 2) {
            return parts[1];
        }
        return threadName;
    }

    static interface EventLoopInfo {
        public int currentConnectionsCount();

        public int currentHttpRequestsCount();
    }
}

