/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.accesslog;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.netty.common.accesslog.AccessLogPublisher;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.AttributeKey;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogChannelHandler
extends CombinedChannelDuplexHandler {
    private static final AttributeKey<RequestState> ATTR_REQ_STATE = AttributeKey.newInstance((String)"_accesslog_requeststate");
    private static final Logger LOG = LoggerFactory.getLogger(AccessLogChannelHandler.class);

    public AccessLogChannelHandler(AccessLogPublisher publisher) {
        super((ChannelInboundHandler)new AccessLogInboundChannelHandler(publisher), (ChannelOutboundHandler)new AccessLogOutboundChannelHandler());
    }

    private static class RequestState {
        LocalDateTime dateTime = LocalDateTime.now();
        HttpRequest request;
        HttpResponse response;
        long startTimeNs;
        int requestBodySize = 0;
        int responseBodySize = 0;

        private RequestState() {
        }
    }

    private static class AccessLogOutboundChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private AccessLogOutboundChannelHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            RequestState state = (RequestState)ctx.channel().attr(ATTR_REQ_STATE).get();
            if (msg instanceof HttpResponse) {
                state.response = (HttpResponse)msg;
                state.responseBodySize = 0;
            }
            if (msg instanceof HttpContent) {
                state.responseBodySize += ((HttpContent)msg).content().readableBytes();
            }
            super.write(ctx, msg, promise);
        }
    }

    private static class AccessLogInboundChannelHandler
    extends ChannelInboundHandlerAdapter {
        private final AccessLogPublisher publisher;

        public AccessLogInboundChannelHandler(AccessLogPublisher publisher) {
            this.publisher = publisher;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            RequestState state;
            if (msg instanceof HttpRequest) {
                state = new RequestState();
                state.request = (HttpRequest)msg;
                state.startTimeNs = System.nanoTime();
                state.requestBodySize = 0;
                ctx.channel().attr(ATTR_REQ_STATE).set((Object)state);
            }
            if (msg instanceof HttpContent && (state = (RequestState)ctx.channel().attr(ATTR_REQ_STATE).get()) != null) {
                state.requestBodySize += ((HttpContent)msg).content().readableBytes();
            }
            super.channelRead(ctx, msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
                RequestState state = (RequestState)ctx.channel().attr(ATTR_REQ_STATE).get();
                ctx.channel().attr(ATTR_REQ_STATE).set(null);
                long durationNs = System.nanoTime() - state.startTimeNs;
                String remoteIp = (String)ctx.channel().attr(SourceAddressChannelHandler.ATTR_SOURCE_ADDRESS).get();
                Integer localPort = (Integer)ctx.channel().attr(SourceAddressChannelHandler.ATTR_SERVER_LOCAL_PORT).get();
                if (state.response == null) {
                    LOG.debug("Response null in AccessLog, Complete reason={}, duration={}, url={}, method={}", new Object[]{((HttpLifecycleChannelHandler.CompleteEvent)evt).getReason(), durationNs / 1000000L, state.request != null ? state.request.uri() : "-", state.request != null ? state.request.method() : "-"});
                }
                this.publisher.log(ctx.channel(), state.request, state.response, state.dateTime, localPort, remoteIp, durationNs, state.requestBodySize, state.responseBodySize);
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

