/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.netty.common.ConnectionCloseType;
import com.netflix.netty.common.HttpChannelFlags;
import com.netflix.netty.common.HttpLifecycleChannelHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http1ConnectionCloseHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http1ConnectionCloseHandler.class);
    private final int gracefulCloseDelay;
    private final AtomicBoolean requestInflight = new AtomicBoolean(Boolean.FALSE);

    public Http1ConnectionCloseHandler(int gracefulCloseDelay) {
        this.gracefulCloseDelay = gracefulCloseDelay;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (HttpChannelFlags.CLOSE_AFTER_RESPONSE.get(ctx)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
            }
        }
        super.write(ctx, msg, promise);
        if (msg instanceof LastHttpContent && HttpChannelFlags.CLOSE_AFTER_RESPONSE.get(ctx)) {
            promise.addListener(future -> ctx.close());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpLifecycleChannelHandler.StartEvent) {
            this.requestInflight.set(Boolean.TRUE);
        } else if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            this.requestInflight.set(Boolean.FALSE);
        }
        super.userEventTriggered(ctx, evt);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ConnectionCloseType type = ConnectionCloseType.fromChannel(ctx.channel());
        this.closeChannel(ctx, type, promise);
    }

    protected void closeChannel(ChannelHandlerContext ctx, ConnectionCloseType evt, ChannelPromise promise) {
        switch (evt) {
            case DELAYED_GRACEFUL: {
                this.gracefully(ctx, promise);
                break;
            }
            case GRACEFUL: {
                this.gracefully(ctx, promise);
                break;
            }
            case IMMEDIATE: {
                this.immediately(ctx, promise);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ConnectionCloseEvent type! - " + String.valueOf((Object)evt));
            }
        }
    }

    protected void gracefully(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.isAlreadyClosing(ctx)) {
            promise.setSuccess();
            return;
        }
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            String channelId = channel.id().asShortText();
            HttpChannelFlags.CLOSE_AFTER_RESPONSE.set(ctx);
            ctx.executor().schedule(() -> {
                if (channel.isActive()) {
                    if (this.requestInflight.get()) {
                        LOG.debug("gracefully: firing graceful_shutdown event to close connection, but request still inflight, so leaving. channel=" + channelId);
                    } else {
                        LOG.debug("gracefully: firing graceful_shutdown event to close connection. channel=" + channelId);
                        ctx.close(promise);
                    }
                } else {
                    LOG.debug("gracefully: connection already closed. channel=" + channelId);
                    promise.setSuccess();
                }
            }, (long)this.gracefulCloseDelay, TimeUnit.SECONDS);
        } else {
            promise.setSuccess();
        }
    }

    protected void immediately(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.isAlreadyClosing(ctx)) {
            promise.setSuccess();
            return;
        }
        if (ctx.channel().isActive()) {
            ctx.close(promise);
        } else {
            promise.setSuccess();
        }
    }

    protected boolean isAlreadyClosing(ChannelHandlerContext ctx) {
        if (HttpChannelFlags.CLOSING.get(ctx)) {
            return true;
        }
        HttpChannelFlags.CLOSING.set(ctx);
        HttpChannelFlags.CLOSE_AFTER_RESPONSE.set(ctx);
        return false;
    }
}

