/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.spring4;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.spring4.context.Beans;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class PebbleView
extends AbstractTemplateView {
    public static final String REQUEST_VARIABLE_NAME = "request";
    public static final String RESPONSE_VARIABLE_NAME = "response";
    public static final String SESSION_VARIABLE_NAME = "session";
    private static final String BEANS_VARIABLE_NAME = "beans";
    private static final int NANOS_IN_SECOND = 1000000;
    private static final Logger TIMER_LOGGER = LoggerFactory.getLogger((String)(PebbleView.class.getName() + ".timer"));
    private String characterEncoding = "UTF-8";
    private PebbleEngine engine;
    private String templateName;

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setPebbleEngine(PebbleEngine engine) {
        this.engine = engine;
    }

    public void setTemplateName(String name) {
        this.templateName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setCharacterEncoding(this.characterEncoding);
        long startNanos = System.nanoTime();
        PebbleTemplate template = this.engine.getTemplate(this.templateName);
        model.put(BEANS_VARIABLE_NAME, new Beans(this.getApplicationContext()));
        model.put(REQUEST_VARIABLE_NAME, request);
        model.put(RESPONSE_VARIABLE_NAME, response);
        model.put(SESSION_VARIABLE_NAME, request.getSession(false));
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        PrintWriter writer = response.getWriter();
        try {
            template.evaluate((Writer)writer, model, locale);
        }
        finally {
            ((Writer)writer).flush();
        }
        if (TIMER_LOGGER.isDebugEnabled()) {
            long endNanos = System.nanoTime();
            BigDecimal elapsed = BigDecimal.valueOf(endNanos - startNanos);
            BigDecimal elapsedMs = elapsed.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP);
            TIMER_LOGGER.debug("Pebble template \"{}\" with locale {} processed in {} nanoseconds (approx. {}ms)", new Object[]{this.templateName, locale, elapsed, elapsedMs});
        }
    }
}

