/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.wechat.msg.JoinGroupMsg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgResolver {
    private static final Logger log = LoggerFactory.getLogger(MsgResolver.class);
    private static final XmlMapper xmlMapper = new XmlMapper();

    public static Map<String, Object> getMainContent(WechatMessage wechatMessage) {
        return MsgResolver.getMainContent(wechatMessage.getMessage());
    }

    public static Map<String, Object> getMainContent(String message) {
        HashMap map = Maps.newHashMap();
        try {
            message = MsgResolver.getInvalidMsg(message);
            JoinGroupMsg joinGroupMessage = (JoinGroupMsg)xmlMapper.readValue(message, JoinGroupMsg.class);
            JoinGroupMsg.ContentTemplate contentTemplate = joinGroupMessage.getSysMsgTemplate().getContentTemplate();
            String template = contentTemplate.getTemplate();
            List<JoinGroupMsg.Link> linklist = contentTemplate.getLinklist();
            Map<String, String> contentMap = MsgResolver.getReplacedContent(linklist);
            if (Objects.nonNull(contentMap)) {
                Set<String> placeholderNames = contentMap.keySet();
                for (String name : placeholderNames) {
                    log.info("placeholder={}", (Object)name);
                    template = template.replace("$" + name + "$", contentMap.get(name));
                }
            }
            map.put("content", template);
            MsgResolver.setRevokeInfo(linklist, map);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5165\u7fa4\u6d88\u606f\u5931\u8d25:{}", (Object)message, (Object)e);
            map.put("content", "[\u8fd9\u662f\u4e00\u6761\u7cfb\u7edf\u6d88\u606f]");
        }
        return map;
    }

    private static void setRevokeInfo(List<JoinGroupMsg.Link> linklist, Map<String, Object> map) {
        for (JoinGroupMsg.Link link : linklist) {
            String qrcode;
            String name = link.getName();
            if (!"revoke".equals(name)) continue;
            ArrayList wechatIds = Lists.newArrayList();
            List<String> usernameList = link.getUsernameList();
            String username = link.getUsername();
            if (CollectionUtils.isNotEmpty(usernameList)) {
                wechatIds.addAll(usernameList);
            } else if (StringUtils.isNotBlank((CharSequence)username)) {
                wechatIds.add(username);
            }
            if (CollectionUtils.isNotEmpty((Collection)wechatIds)) {
                map.put("usernameList", wechatIds);
            }
            if (StringUtils.isNotBlank((CharSequence)(qrcode = link.getQrcode()))) {
                map.put("qrcode", qrcode);
            }
            return;
        }
    }

    private static Map<String, String> getReplacedContent(List<JoinGroupMsg.Link> linklist) {
        if (CollectionUtils.isEmpty(linklist)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        linklist.forEach(link -> {
            String name = link.getName();
            String value = "";
            List<JoinGroupMsg.Member> memberList = link.getMemberList();
            String plain = link.getPlain();
            String title = link.getTitle();
            if (CollectionUtils.isNotEmpty(memberList)) {
                String separator = link.getSeparator();
                value = Objects.nonNull(separator) ? MsgResolver.buildMemberListStr(memberList, separator) : memberList.get(0).getNickname();
            } else if (Objects.nonNull(title)) {
                value = title;
            } else if (Objects.nonNull(plain)) {
                value = plain;
            }
            map.put(name, value);
        });
        return map;
    }

    private static String buildMemberListStr(List<JoinGroupMsg.Member> memberList, String separator) {
        StringBuilder builder = new StringBuilder();
        int size = memberList.size();
        for (int i = 0; i < size; ++i) {
            builder.append(memberList.get(i).getNickname());
            if (i == size - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    private static String getInvalidMsg(String msg) throws Exception {
        String start = "<sysmsg";
        String end = "</sysmsg>";
        int index = msg.indexOf(start);
        int endIndex = msg.indexOf(end);
        if (index == -1 || endIndex == -1) {
            throw new Exception("\u6d88\u606f\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        msg = msg.substring(index, endIndex + end.length());
        return msg;
    }

    static {
        xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

