/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.google.common.collect.Lists;
import com.kuaike.skynet.logic.wechat.msg.JoinGroupMsg;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class JoinGroupDto {
    public static final int INVITE = 1;
    public static final int SCAN_CODE = 2;
    public static final int CREATE = 3;
    private int type;
    private JoinGroupMsg.Member inviter;
    private List<JoinGroupMsg.Member> memberList;

    public String getInviteWechatId() {
        if (this.inviter != null) {
            return this.inviter.getUsername();
        }
        return null;
    }

    public List<String> getMemberIds() {
        if (CollectionUtils.isNotEmpty(this.memberList)) {
            return this.memberList.stream().map(JoinGroupMsg.Member::getUsername).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public int getType() {
        return this.type;
    }

    public JoinGroupMsg.Member getInviter() {
        return this.inviter;
    }

    public List<JoinGroupMsg.Member> getMemberList() {
        return this.memberList;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setInviter(JoinGroupMsg.Member inviter) {
        this.inviter = inviter;
    }

    public void setMemberList(List<JoinGroupMsg.Member> memberList) {
        this.memberList = memberList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinGroupDto)) {
            return false;
        }
        JoinGroupDto other = (JoinGroupDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        JoinGroupMsg.Member this$inviter = this.getInviter();
        JoinGroupMsg.Member other$inviter = other.getInviter();
        if (this$inviter == null ? other$inviter != null : !((Object)this$inviter).equals(other$inviter)) {
            return false;
        }
        List<JoinGroupMsg.Member> this$memberList = this.getMemberList();
        List<JoinGroupMsg.Member> other$memberList = other.getMemberList();
        return !(this$memberList == null ? other$memberList != null : !((Object)this$memberList).equals(other$memberList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinGroupDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        JoinGroupMsg.Member $inviter = this.getInviter();
        result = result * 59 + ($inviter == null ? 43 : ((Object)$inviter).hashCode());
        List<JoinGroupMsg.Member> $memberList = this.getMemberList();
        result = result * 59 + ($memberList == null ? 43 : ((Object)$memberList).hashCode());
        return result;
    }

    public String toString() {
        return "JoinGroupDto(type=" + this.getType() + ", inviter=" + this.getInviter() + ", memberList=" + this.getMemberList() + ")";
    }

    public JoinGroupDto() {
    }

    public JoinGroupDto(int type, JoinGroupMsg.Member inviter, List<JoinGroupMsg.Member> memberList) {
        this.type = type;
        this.inviter = inviter;
        this.memberList = memberList;
    }
}

