/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.wechat.msg.BaseAppMsg;
import com.kuaike.skynet.logic.wechat.utils.MsgUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractMsgHandler.class);
    protected XmlMapper xmlMapper = new XmlMapper();

    public AbstractMsgHandler() {
        this.xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public void dispatch(WechatMessage wechatMessage) {
        log.info("dispatch msg type={}, talkerType={}, isSend={}, requestId={}", new Object[]{wechatMessage.getType(), wechatMessage.getTalkerType(), wechatMessage.getIsSend(), wechatMessage.getRequestId()});
        switch (wechatMessage.getType()) {
            case 1: {
                String message = wechatMessage.getMessage();
                if (message != null && message.contains("ticket") && message.contains("opcode") && message.contains("scene")) {
                    this.onWaitJoinFriendEvent(wechatMessage);
                    return;
                }
                this.text(wechatMessage);
                return;
            }
            case 3: 
            case 23: 
            case 33: {
                this.image(wechatMessage);
                return;
            }
            case 11: 
            case 36: {
                this.unknown(wechatMessage);
                return;
            }
            case 34: {
                this.voice(wechatMessage);
                return;
            }
            case 37: {
                this.unknown(wechatMessage);
                return;
            }
            case 13: 
            case 39: {
                this.unknown(wechatMessage);
                return;
            }
            case 42: 
            case 66: {
                this.visitingCard(wechatMessage);
                return;
            }
            case 43: 
            case 62: {
                this.video(wechatMessage);
                return;
            }
            case 47: 
            case 0x100031: {
                this.gif(wechatMessage);
                return;
            }
            case 48: {
                this.location(wechatMessage);
                return;
            }
            case 49: 
            case 0x1000031: 
            case 0x10000031: 
            case 553648177: 
            case 587202609: 
            case 687865905: {
                this.xmlAppMsg(wechatMessage);
                return;
            }
            case 523: 
            case 526: {
                this.miniProgram(wechatMessage);
                return;
            }
            case 50: 
            case 53: {
                this.unknown(wechatMessage);
                return;
            }
            case 52: 
            case 12299999: {
                this.unknown(wechatMessage);
                return;
            }
            case 55: 
            case 57: {
                this.unknown(wechatMessage);
                return;
            }
            case 0x11000031: {
                this.unknown(wechatMessage);
                return;
            }
            case 0x13000031: {
                this.unknown(wechatMessage);
                return;
            }
            case 335544369: {
                this.unknown(wechatMessage);
                return;
            }
            case 369098801: {
                this.unknown(wechatMessage);
                return;
            }
            case 402653233: {
                this.unknown(wechatMessage);
                return;
            }
            case 419430449: {
                this.transferMoney(wechatMessage);
                return;
            }
            case 436207665: 
            case 469762097: {
                this.redPack(wechatMessage);
                return;
            }
            case 452984881: {
                this.unknown(wechatMessage);
                return;
            }
            case 503316529: {
                this.unknown(wechatMessage);
                return;
            }
            case 520093745: {
                this.unknown(wechatMessage);
                return;
            }
            case 536870961: {
                this.unknown(wechatMessage);
                return;
            }
            case 570425393: {
                this.onJoinGroupEvent(wechatMessage);
                return;
            }
            case 603979825: {
                this.unknown(wechatMessage);
                return;
            }
            case 671088689: {
                this.unknown(wechatMessage);
                return;
            }
            case 10000: {
                this.sysMsg(wechatMessage);
                return;
            }
            case 10002: {
                this.chatRoomAccessVerifyApplication(wechatMessage);
                return;
            }
            case 495: {
                this.appUrl(wechatMessage);
                return;
            }
        }
        this.unknown(wechatMessage);
    }

    public void text(WechatMessage wechatMessage) {
        log.info("text is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void image(WechatMessage wechatMessage) {
        log.info("image is not processed, requestId={}, talkerId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void voice(WechatMessage wechatMessage) {
        log.info("voice is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void video(WechatMessage wechatMessage) {
        log.info("video is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void visitingCard(WechatMessage wechatMessage) {
        log.info("visiting card is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void gif(WechatMessage wechatMessage) {
        log.info("gif is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    protected void sysMsg(WechatMessage wechatMessage) {
        String message = wechatMessage.getMessage();
        if (MsgUtils.match(message, MsgUtils.FRIEND_IS_JOINED_PATTERN) || MsgUtils.match(message, MsgUtils.FRIEND_IS_JOINED_PATTERN_3)) {
            this.onJoinedByFriendEvent(wechatMessage);
        } else if (MsgUtils.match(message, MsgUtils.JOINED_BY_FRIEND_PATTERN)) {
            this.onJoinedByFriendEvent(wechatMessage);
        } else if (MsgUtils.match(message, MsgUtils.GROUP_YOU_ARE_OWNER_PATTERN)) {
            this.onBecomeOwnerEvent(wechatMessage);
        } else if (MsgUtils.match(message, MsgUtils.GROUP_YOU_ARE_KICKED_PATTERN)) {
            this.onKickedEvent(wechatMessage);
        } else {
            this.onUnknownSysMsg(wechatMessage);
        }
    }

    public void chatRoomAccessVerifyApplication(WechatMessage wechatMessage) {
        log.info("Recv ChatRoomAccessVerifyApplication is not processed, requestId={}, wechatId={}, message={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getWechatId(), wechatMessage.getMessage()});
    }

    public void transferMoney(WechatMessage wechatMessage) {
        log.info("transfer money is not processed, requestId={}", (Object)wechatMessage.getRequestId());
        int type = 0;
        switch (type) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public void redPack(WechatMessage wechatMessage) {
        log.info("red pack is not processed, requestId={}", (Object)wechatMessage.getRequestId());
    }

    public void location(WechatMessage wechatMessage) {
        log.info("location is not processed, requestId={}", (Object)wechatMessage.getRequestId());
    }

    protected void xmlShakeMsg(WechatMessage wechatMessage) {
        log.info("dispatch shake hand msg, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        int sence = 0;
        switch (sence) {
            case 18: {
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 25: {
                break;
            }
        }
        this.unknown(wechatMessage);
    }

    protected void xmlAppMsg(WechatMessage wechatMessage) {
        log.info("dispatch appmsg, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        if (StringUtils.isBlank((CharSequence)wechatMessage.getMessage())) {
            log.warn("XmlAppMsg is blank, requestId={}, isSend={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getIsSend());
            return;
        }
        int type = 0;
        BaseAppMsg msg = null;
        try {
            msg = (BaseAppMsg)this.xmlMapper.readValue(wechatMessage.getMessage(), BaseAppMsg.class);
            type = msg.getAppmsg().getType();
            log.info("appmsg={}", (Object)msg);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5e94\u7528\u6d88\u606f\u5931\u8d25, requestId={}, xml={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getMessage(), e});
        }
        switch (type) {
            case 1: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 2: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 3: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 4: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 5: {
                this.appUrl(wechatMessage);
                return;
            }
            case 6: {
                this.file(wechatMessage);
                return;
            }
            case 7: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 8: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 15: 
            case 26: 
            case 27: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 16: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 17: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 19: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 24: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 25: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 33: {
                this.miniProgram(wechatMessage);
                return;
            }
            case 36: {
                this.miniProgram(wechatMessage);
                return;
            }
            case 34: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 40: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 44: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
            case 46: {
                this.onUnknownAppMsg(wechatMessage);
                return;
            }
        }
        this.onUnknownAppMsg(wechatMessage);
    }

    public void appUrl(WechatMessage wechatMessage) {
        log.info("AppUrl is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void file(WechatMessage wechatMessage) {
        log.info("File is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void miniProgram(WechatMessage wechatMessage) {
        log.info("MiniProgram is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void onJoinGroupEvent(WechatMessage wechatMessage) {
        log.info("JoinGroupEvent is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void onWaitJoinFriendEvent(WechatMessage wechatMessage) {
        log.info("WaitJoinFriendEvent is not processed, requestId={}", (Object)wechatMessage.getRequestId());
    }

    public void onFriendIsJoinedEvent(WechatMessage wechatMessage) {
        log.info("FriendIsJoinedEvent is not processed, requestId={}", (Object)wechatMessage.getRequestId());
    }

    public void onJoinedByFriendEvent(WechatMessage wechatMessage) {
        log.info("JoinedByFriendEvent is not processed, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
    }

    public void onBecomeOwnerEvent(WechatMessage wechatMessage) {
        log.info("BecomeOwnerEvent is not processed, requestId={}", (Object)wechatMessage.getRequestId());
    }

    public void onKickedEvent(WechatMessage wechatMessage) {
        log.info("KickedEvent is not processed, requestId={}", (Object)wechatMessage.getRequestId());
    }

    public void unknown(WechatMessage wechatMessage) {
        log.info("Receive unknown msg, requestId={}, type={}, wechatId={}, talkerId={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getType(), wechatMessage.getWechatId(), wechatMessage.getTalkerId()});
    }

    public void onUnknownAppMsg(WechatMessage wechatMessage) {
        log.info("Receive unknown appmsg, requestId={}, type={}, wechatId={}, talkerId={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getType(), wechatMessage.getWechatId(), wechatMessage.getTalkerId()});
    }

    public void onUnknownSysMsg(WechatMessage wechatMessage) {
        log.info("Receive unknown sysmsg, requestId={}, type={}, wechatId={}, talkerId={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getType(), wechatMessage.getWechatId(), wechatMessage.getTalkerId()});
    }
}

