/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.wechat.enums;

import java.util.HashMap;
import java.util.Map;

public enum JoinGroupType {
    INVITE_1_SIMPLIFIED("\"$username$\"\u9080\u8bf7\u4f60\u548c\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a", 1),
    INVITE_2_SIMPLIFIED("\"$username$\"\u9080\u8bf7\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a", 2),
    INVITE_3_SIMPLIFIED("\u4f60\u9080\u8bf7\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a  $revoke$", 3),
    INVITE_4_SIMPLIFIED("\"$username$\"\u9080\u8bf7\u4f60\u52a0\u5165\u4e86\u7fa4\u804a\uff0c\u7fa4\u804a\u53c2\u4e0e\u4eba\u8fd8\u6709\uff1a$others$", 4),
    INVITE_5_SIMPLIFIED("\"$username$\"\u9080\u8bf7\u4f60\u52a0\u5165\u4e86\u7fa4\u804a", 5),
    SCAN_CODE_11_SIMPLIFIED("\"$adder$\"\u901a\u8fc7\u626b\u63cf\u4f60\u5206\u4eab\u7684\u4e8c\u7ef4\u7801\u52a0\u5165\u7fa4\u804a  $revoke$", 11),
    SCAN_CODE_12_SIMPLIFIED("\" $adder$\"\u901a\u8fc7\u626b\u63cf\"$from$\"\u5206\u4eab\u7684\u4e8c\u7ef4\u7801\u52a0\u5165\u7fa4\u804a", 12),
    CREATE_21_SIMPLIFIED("\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a", 21),
    QUIT_GROUP_BY_KICK_SIMPLIFIED("\u4f60\u5c06\"$kickoutname$\"\u79fb\u51fa\u4e86\u7fa4\u804a", 101),
    MOD_GROUP_NAME_SIMPLIFIED("\"$username$\"\u4fee\u6539\u7fa4\u540d\u4e3a\u201c$remark$\u201d", 201),
    OWNER_CHANGED_SIMPLIFIED("\"$ownername$\"\u5df2\u6210\u4e3a\u65b0\u7fa4\u4e3b", 301),
    INVITE_1_TRADITIONAL("\u300c$username$\u300d\u9080\u8acb\u4f60\u548c$names$\u52a0\u5165\u4e86\u7fa4\u7d44", 1),
    INVITE_2_TRADITIONAL("\u300c$username$\u300d\u9080\u8acb\u300c$names$\u300d\u52a0\u5165\u4e86\u7fa4\u7d44", 2),
    INVITE_3_TRADITIONAL("\u4f60\u9080\u8acb\u300c$names$\u300d\u52a0\u5165\u4e86\u7fa4\u7d44  $revoke$", 3),
    INVITE_4_TRADITIONAL("\u300c$username$\u300d\u9080\u8acb\u4f60\u52a0\u5165\u4e86\u7fa4\u7d44\uff0c\u6210\u54e1\u9084\u6709\uff1a$others$", 4),
    INVITE_5_TRADITIONAL("\u300c$username$\u300d\u9080\u8acb\u4f60\u52a0\u5165\u4e86\u7fa4\u7d44", 5),
    SCAN_CODE_11_TRADITIONAL("\u300c$adder$\u300d\u900f\u904e\u6383\u63cf\u4f60\u5206\u4eab\u7684QR code\u52a0\u5165\u7fa4\u7d44  $revoke$", 11),
    SCAN_CODE_12_TRADITIONAL("\u300c$adder$\u300d\u900f\u904e\u6383\u63cf\u300c$from$\u300d\u5206\u4eab\u7684QR Code\u52a0\u5165\u7fa4\u7d44\u3002", 12),
    CREATE_21_TRADITIONAL("\u300c$names$\u300d\u52a0\u5165\u4e86\u7fa4\u7d44", 21),
    QUIT_GROUP_BY_KICK_TRADITIONAL("\u4f60\u5c07\u300c$kickoutname$\u300d\u79fb\u51fa\u4e86\u7fa4\u7d44", 101),
    MOD_GROUP_NAME_TRADITIONAL("\u300c$username$\u300d\u4fee\u6539\u7fa4\u540d\u70ba\u300c$remark$\u300d", 201),
    OWNER_CHANGED_TRADITIONAL("\"$ownername$\"\u5df2\u6210\u70ba\u65b0\u7fa4\u7d44\u5efa\u7acb\u8005", 301),
    INVITE_1_ENGLISH("invited you and $names$ to the group chat", 1),
    INVITE_2_ENGLISH("$username$ invited $names$ to the group chat", 2),
    INVITE_3_ENGLISH("You invited $names$ to the group chat.   $revoke$", 3),
    INVITE_4_ENGLISH("$username$ invited you to a group chat with $others$", 4),
    INVITE_5_ENGLISH("$username$ invited you to the group chat", 5),
    SCAN_CODE_11_ENGLISH("\"$adder$\" joined group chat via the QR code you shared.  $revoke$", 11),
    SCAN_CODE_12_ENGLISH("\"$adder$\" joined the group chat via the QR Code shared by \"$from$\".", 12),
    CREATE_21_ENGLISH("\"$names$\" joined the group chat.", 21),
    QUIT_GROUP_BY_KICK_ENGLISH("You moved \"$kickoutname $\" out of group chat.", 101),
    MOD_GROUP_NAME_ENGLISH("\"$username$\" changed the group name to \u201c$remark$\u201d", 201),
    OWNER_CHANGED_ENGLISH("\"$ownername$\" changed the group owner", 301);

    private static final Map<String, JoinGroupType> MAP;
    public static final Map<Integer, String> JOIN_GROUP_TYPE_TO_DES_MAP;
    private static final int INVITE = 1;
    private static final int SCAN_CODE = 2;
    private static final int CREATE = 3;
    private final String template;
    private final int type;

    private JoinGroupType(String template, int type) {
        this.template = template;
        this.type = type;
    }

    public static String getJoinGroupTypeDesc(int type) {
        return JOIN_GROUP_TYPE_TO_DES_MAP.get(type);
    }

    public static JoinGroupType getJoinGroupSubType(String template) {
        return MAP.get(template);
    }

    public static Integer getJoinGroupType(int type) {
        if (type <= 10) {
            return 1;
        }
        if (type <= 20) {
            return 2;
        }
        return 3;
    }

    public String getTemplate() {
        return this.template;
    }

    public int getType() {
        return this.type;
    }

    public static boolean isJoinGroupType(JoinGroupType joinGroupType) {
        return joinGroupType.getType() < 100;
    }

    public static boolean isExitGroup(JoinGroupType joinGroupType) {
        return joinGroupType.getType() > 100 && joinGroupType.getType() < 200;
    }

    public static boolean isModGroupName(JoinGroupType joinGroupType) {
        return joinGroupType.getType() > 200 && joinGroupType.getType() < 300;
    }

    public static boolean isChangeGroupOwner(JoinGroupType joinGroupType) {
        return joinGroupType.getType() > 300 && joinGroupType.getType() < 400;
    }

    static {
        MAP = new HashMap<String, JoinGroupType>();
        JOIN_GROUP_TYPE_TO_DES_MAP = new HashMap<Integer, String>();
        for (JoinGroupType e : JoinGroupType.values()) {
            MAP.put(e.getTemplate(), e);
        }
        JOIN_GROUP_TYPE_TO_DES_MAP.put(1, "\u9080\u8bf7\u5165\u7fa4");
        JOIN_GROUP_TYPE_TO_DES_MAP.put(2, "\u626b\u7801\u5165\u7fa4");
        JOIN_GROUP_TYPE_TO_DES_MAP.put(3, "\u9762\u5bf9\u9762\u5efa\u7fa4");
    }
}

