/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title TransferMoneyMsg
 * @author yanmaoyuan
 * @date 2019年12月10日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class TransferMoneyMsg {

    private TransferMoneyAppMsg appmsg;

    @Data
    @EqualsAndHashCode(callSuper=false)
    public static class TransferMoneyAppMsg extends AppMsg {

        private String action;

        private String content;

        @JacksonXmlProperty(localName = "lowurl")
        private String lowUrl;

        private String extinfo;

        @JacksonXmlProperty(localName = "wcpayinfo")
        private WechatPayInfo wechatPayInfo;
    }

    @Data
    public static class WechatPayInfo {

        @JacksonXmlProperty(localName = "paysubtype")
        private Integer paySubType;

        @JacksonXmlProperty(localName = "feedesc")
        private String feeDesc;

        @JacksonXmlProperty(localName = "transcationid")
        private String transcationId;

        @JacksonXmlProperty(localName = "transferid")
        private String transferId;

        /**
         * 失效的时间戳，单位:秒
         */
        @JacksonXmlProperty(localName = "invalidtime")
        private Long invalidTime;

        @JacksonXmlProperty(localName = "begintransfertime")
        private Long beginTransferTime;

        @JacksonXmlProperty(localName = "effectivedate")
        private Integer effectiveDate;

        @JacksonXmlProperty(localName = "pay_memo")
        private String payMemo;
    }
}