/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;

/**
 * eg:
 * 
 * <pre>
 * <msgsource>
 *     <atuserlist><![CDATA[wxid_hi2q4bvy63cc22,wxid_uc11ozwmb08l12]]></atuserlist>
 *     <silence>0</silence>
 *     <membercount>26</membercount>
 * </msgsource>
 * </pre>
 * @title AtUserList
 * @author yanmaoyuan
 * @date 2020年4月13日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msgsource")
public class AtUserList {

    private Integer silence;

    @JacksonXmlProperty(localName = "membercount")
    private Integer memberCount;
    
    @JacksonXmlProperty(localName = "atuserlist")
    @JacksonXmlCData
    private String atUserList;
}
