/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;

/**
 * 
 * 注意，这本身不是一个消息，而是一个微信系统事件，表示有人把当前微信添加成了好友。前端把这个Event当作消息上报给了后台。</br>
 * 
 * 这个Msg的type = 1，与文本消息是一样的，容易造成迷惑。但它本质上是一个Event。</br>
 * 
 * 这个事件的message中是一段xml:
 * 
 * <pre>
 * &lt;msg fromusername=\"lixiaobin5555\" encryptusername=\"v1_8c78ff11cffaa5389c04c94e6cd66645c68fa323852ccdd18c05b9ef7c55e1d7@stranger\" fromnickname=\"李小斌\" content=\"我是李小斌\" fullpy=\"lixiaobin\" shortpy=\"LXB\" imagestatus=\"3\" scene=\"30\" country=\"CN\" province=\"Beijing\" city=\"Haidian\" sign=\"出于心，善于行。\" percard=\"1\" sex=\"1\" alias=\"lixiaobin8878\" weibo=\"\" albumflag=\"0\" albumstyle=\"0\" albumbgimgid=\"\" snsflag=\"17\" snsbgimgid=\"http://szmmsns.qpic.cn/mmsns/rtW7PSHfHWcZtvpiaBmTlJNUT31TzI7t4R1zbFMbThJdh9PjnydiaX2uTSfiaB5iclYDRT7xseK6iclk/0\" snsbgobjectid=\"12743934841637376255\" mhash=\"d7f2257aa5db934ca18f1863019ee5e8\" mfullhash=\"d7f2257aa5db934ca18f1863019ee5e8\" bigheadimgurl=\"http://wx.qlogo.cn/mmhead/ver_1/ocjrxeMcTNxROsiaXntRUrzhjICYulGlia2m6tT6YMjkMDVZLoUAp8asLZtzuJBp8fO1dC7xO3V6w9kyDyoPkkRdibj0eqQKeUibIRozb46IL90/0\" smallheadimgurl=\"http://wx.qlogo.cn/mmhead/ver_1/ocjrxeMcTNxROsiaXntRUrzhjICYulGlia2m6tT6YMjkMDVZLoUAp8asLZtzuJBp8fO1dC7xO3V6w9kyDyoPkkRdibj0eqQKeUibIRozb46IL90/96\" ticket=\"v2_c7f95e7238538ef67f6aeaa16d9c5fab33e3671520359f242b4cba652441456f91b93304fa3e579701f18adbacf44b983a8155a955c43a530e883035c348bdd5379220a29ab730373723667d19cdfc69@stranger\" opcode=\"2\" googlecontact=\"\" qrticket=\"\" chatroomusername=\"\" sourceusername=\"\" sourcenickname=\"\" sharecardusername=\"\" sharecardnickname=\"\" cardversion=\"\"&gt;
 *     &lt;brandlist count=\"0\" ver=\"682851723\"&gt;&lt;/brandlist&gt;
 * &lt;/msg&gt;
 * </pre>
 * 
 * @title WaitJoinFriendEvent
 * @author yanmaoyuan
 * @date 2019年12月11日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class WaitJoinFriendEvent {

    @JacksonXmlProperty(localName = "fromusername", isAttribute = true)
    private String fromUsername;

    @JacksonXmlProperty(localName = "encryptusername", isAttribute = true)
    private String encryptUsername;

    @JacksonXmlProperty(localName = "fromnickname", isAttribute = true)
    private String fromNickname;

    /**
     * 添加好友时写的申请理由
     */
    @JacksonXmlProperty(isAttribute = true)
    private String content;

    /**
     * 名字的拼音，如zhangsan
     */
    @JacksonXmlProperty(isAttribute = true)
    private String fullpy;

    /**
     * 名字拼音首字母的缩写，如ZS
     */
    private String shortpy;

    @JacksonXmlProperty(localName = "imagestatus", isAttribute = true)
    private String imageStatus;// int

    @JacksonXmlProperty(isAttribute = true)
    private Integer scene;// int

    @JacksonXmlProperty(isAttribute = true)
    private String country;

    @JacksonXmlProperty(isAttribute = true)
    private String province;

    @JacksonXmlProperty(isAttribute = true)
    private String city;

    /**
     * 微信用户的个性签名
     */
    @JacksonXmlProperty(isAttribute = true)
    private String sign;

    @JacksonXmlProperty(isAttribute = true)
    private String percard;

    @JacksonXmlProperty(isAttribute = true)
    private Integer sex;// int

    /**
     * 微信号的别名
     */
    @JacksonXmlProperty(isAttribute = true)
    private String alias;

    @JacksonXmlProperty(isAttribute = true)
    private String weibo;

    @JacksonXmlProperty(localName = "albumflag", isAttribute = true)
    private String albumFlag;// int?

    @JacksonXmlProperty(localName = "albumstyle", isAttribute = true)
    private String albumStyle;// int?

    @JacksonXmlProperty(localName = "albumbgimgid", isAttribute = true)
    private String albumBgImgId;

    @JacksonXmlProperty(localName = "snsflag", isAttribute = true)
    private String snsFlag;// int?

    @JacksonXmlProperty(localName = "snsbgimgid", isAttribute = true)
    private String snsBgImgId;// 朋友圈的背景图片url

    @JacksonXmlProperty(localName = "snsbgobjectid", isAttribute = true)
    private String snsBgObjectId;

    @JacksonXmlProperty(localName = "mhash", isAttribute = true)
    private String mHash;

    @JacksonXmlProperty(localName = "mfullhash", isAttribute = true)
    private String mFullHash;

    @JacksonXmlProperty(localName = "bigheadimgurl", isAttribute = true)
    private String bigHeadImgUrl;// 头像大图url

    @JacksonXmlProperty(localName = "smallheadimgurl", isAttribute = true)
    private String smallHeadImgUrl;// 头像小图url

    @JacksonXmlProperty(isAttribute = true)
    private String ticket;

    @JacksonXmlProperty(isAttribute = true)
    private String opcode;// int?

    @JacksonXmlProperty(localName = "googlecontact", isAttribute = true)
    private String googleContact;

    @JacksonXmlProperty(localName = "qrticket", isAttribute = true)
    private String qrticket;

    @JacksonXmlProperty(localName = "chatroomusername", isAttribute = true)
    private String chatroomUsername;

    @JacksonXmlProperty(localName = "sourceusername", isAttribute = true)
    private String sourceUsername;

    @JacksonXmlProperty(localName = "sourcenickname", isAttribute = true)
    private String sourceNickname;

    @JacksonXmlProperty(localName = "sharecardusername", isAttribute = true)
    private String shareCardUsername;

    @JacksonXmlProperty(localName = "sharecardnickname", isAttribute = true)
    private String shareCardNickname;

    @JacksonXmlProperty(localName = "cardversion", isAttribute = true)
    private String cardVersion;

    // 这个xml中还有一段<brandList/>元素，但是目前看起来还没啥用，就不处理了。
}